/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.geronimo.webservices.Handler;
import org.apache.geronimo.webservices.ServiceImplBean;

public class PortComponent {
    private String portComponentName;
    private String wsdlPort;
    private String serviceEndpointInterface;
    private ServiceImplBean serviceImplBean;
    private ArrayList handlerList = new ArrayList();
    private HashMap handlerMap = new HashMap();

    public void addHandler(Handler handler) throws IndexOutOfBoundsException {
        this.handlerList.add(handler);
        this.handlerMap.put(handler.getHandlerName(), handler);
    }

    public void addHandler(int index, Handler handler) throws IndexOutOfBoundsException {
        this.handlerList.add(index, handler);
        this.handlerMap.put(handler.getHandlerName(), handler);
    }

    public boolean removeHandler(Handler handler) {
        this.handlerMap.remove(handler.getHandlerName());
        return this.handlerList.remove(handler);
    }

    public Handler getHandler(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.handlerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Handler)this.handlerList.get(index);
    }

    public Handler[] getHandler() {
        int size = this.handlerList.size();
        Handler[] mArray = new Handler[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Handler)this.handlerList.get(index);
        }
        return mArray;
    }

    public Handler getHandler(String handlerName) {
        return (Handler)this.handlerMap.get(handlerName);
    }

    public void setHandler(int index, Handler handler) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.handlerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        Handler removed = this.handlerList.set(index, handler);
        this.handlerMap.remove(removed.getHandlerName());
        this.handlerMap.put(handler.getHandlerName(), handler);
    }

    public void setHandler(Handler[] handlerArray) {
        this.handlerList.clear();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            this.handlerList.add(handler);
            this.handlerMap.put(handler.getHandlerName(), handler);
        }
    }

    public void clearHandler() {
        this.handlerList.clear();
        this.handlerMap.clear();
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public String getWsdlPort() {
        return this.wsdlPort;
    }

    public void setWsdlPort(String wsdlPort) {
        this.wsdlPort = wsdlPort;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public ServiceImplBean getServiceImplBean() {
        return this.serviceImplBean;
    }

    public void setServiceImplBean(ServiceImplBean serviceImplBean) {
        this.serviceImplBean = serviceImplBean;
    }
}

