/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.security;

import java.util.HashSet;
import java.util.Set;

public class HTTPMethods {
    private final Set<String> methods = new HashSet<String>();
    private boolean isExcluded = false;

    public HTTPMethods(Set<String> httpMethods, boolean isExcluded) {
        this.isExcluded = isExcluded;
        this.methods.addAll(httpMethods);
    }

    public HTTPMethods(HTTPMethods httpMethods, boolean complemented) {
        this.isExcluded = httpMethods.isExcluded ^ complemented;
        this.methods.addAll(httpMethods.methods);
    }

    public void add(Set<String> httpMethods, boolean addedMethodsExcluded) {
        if (this.isExcluded && httpMethods.isEmpty()) {
            return;
        }
        if (httpMethods.size() == 0) {
            this.isExcluded = addedMethodsExcluded;
            this.methods.clear();
            return;
        }
        if (this.isExcluded) {
            if (addedMethodsExcluded) {
                this.methods.retainAll(httpMethods);
            } else {
                this.methods.removeAll(httpMethods);
            }
        } else if (addedMethodsExcluded) {
            HashSet<String> tempHttpMethods = new HashSet<String>(httpMethods);
            tempHttpMethods.removeAll(this.methods);
            this.methods.clear();
            this.methods.addAll(tempHttpMethods);
            this.isExcluded = true;
        } else {
            this.methods.addAll(httpMethods);
        }
    }

    public HTTPMethods add(HTTPMethods httpMethods) {
        this.add(httpMethods.methods, httpMethods.isExcluded);
        return this;
    }

    public HTTPMethods remove(HTTPMethods httpMethods) {
        if (this.isExcluded) {
            if (httpMethods.isExcluded) {
                this.isExcluded = false;
                HashSet<String> toRemove = new HashSet<String>(this.methods);
                this.methods.clear();
                this.methods.addAll(httpMethods.methods);
                this.methods.removeAll(toRemove);
            } else {
                this.methods.addAll(httpMethods.methods);
            }
        } else if (httpMethods.isExcluded) {
            this.methods.retainAll(httpMethods.methods);
        } else {
            this.methods.removeAll(httpMethods.methods);
        }
        if (!this.isExcluded && this.methods.isEmpty()) {
            return null;
        }
        return this;
    }

    public String getHttpMethods() {
        return this.getHttpMethodsBuffer(this.isExcluded).toString();
    }

    public StringBuilder getHttpMethodsBuffer() {
        return this.getHttpMethodsBuffer(this.isExcluded);
    }

    public String getComplementedHttpMethods() {
        return this.getHttpMethodsBuffer(!this.isExcluded).toString();
    }

    private StringBuilder getHttpMethodsBuffer(boolean excluded) {
        StringBuilder buffer = new StringBuilder();
        if (excluded) {
            buffer.append("!");
        }
        boolean afterFirst = false;
        for (String method : this.methods) {
            if (afterFirst) {
                buffer.append(",");
            } else {
                afterFirst = true;
            }
            buffer.append(method);
        }
        return buffer;
    }

    public boolean isNone() {
        return !this.isExcluded && this.methods.isEmpty();
    }
}

