/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.geronimo.web.info.AuthConstraintInfo;
import org.apache.geronimo.web.info.SecurityConstraintInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web.info.WebResourceCollectionInfo;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSecurityConstraintStore {
    private static final Logger logger = LoggerFactory.getLogger(WebSecurityConstraintStore.class);
    private boolean annotationScanRequired;
    private Bundle bundle;
    private Map<Servlet, String> containerCreatedDynamicServlets = new IdentityHashMap<Servlet, String>();
    private Map<String, String> containerCreatedDynamicServletNameClassMap = new HashMap<String, String>();
    private Map<String, ServletSecurityElement> dynamicServletNameSecurityElementMap = new LinkedHashMap<String, ServletSecurityElement>();
    private Map<RegistrationKey, ServletSecurityElement> registrationSecurityElementMap = new LinkedHashMap<RegistrationKey, ServletSecurityElement>();
    private Set<String> securityRoles = new HashSet<String>();
    private ServletContext servletContext;
    private WebAppInfo webXmlAppInfo;
    private Set<String> webXmlConstraintUrlPatterns = new HashSet<String>();

    public WebSecurityConstraintStore(WebAppInfo webXmlAppInfo) {
        this(webXmlAppInfo, null, false, null);
    }

    public WebSecurityConstraintStore(WebAppInfo webXmlAppInfo, Bundle bundle, boolean annotationScanRequired, ServletContext servletContext) {
        this.webXmlAppInfo = webXmlAppInfo;
        if (annotationScanRequired && bundle == null) {
            throw new IllegalArgumentException("Bundle parameter could not be null while annotation scanning is required");
        }
        this.bundle = bundle;
        this.servletContext = servletContext;
        this.annotationScanRequired = annotationScanRequired;
        this.initialize();
    }

    public void setAnnotationScanRequired(boolean scanRequired) {
        this.annotationScanRequired = scanRequired;
    }

    public void addContainerCreatedDynamicServlet(Servlet servlet) {
        this.containerCreatedDynamicServlets.put(servlet, null);
    }

    public boolean isContainerCreatedDynamicServlet(Servlet servlet) {
        return this.containerCreatedDynamicServlets.containsKey(servlet);
    }

    public void addContainerCreatedDynamicServletEntry(ServletRegistration.Dynamic registration, String servletClass) {
        ServletSecurityElement servletSecurityElement;
        if (this.annotationScanRequired && (servletSecurityElement = this.processServletConstraintAnnotation(servletClass)) != null) {
            this.setDynamicServletSecurity(registration, servletSecurityElement);
        }
    }

    public void addContainerCreatedDynamicServletEntry(String servletName, String servletClass) {
        this.containerCreatedDynamicServletNameClassMap.put(servletName, servletClass);
    }

    public void declareRoles(String ... roleNames) {
        for (String roleName : roleNames) {
            if (roleName == null || roleName.trim().length() == 0) {
                throw new IllegalArgumentException("RoleName of null value or empty string is not allowed in declareRoles method");
            }
            this.securityRoles.add(roleName);
        }
    }

    public WebAppInfo exportMergedWebAppInfo() {
        Collection urlPatterns;
        ArrayList<SecurityConstraintInfo> securityConstraints = new ArrayList<SecurityConstraintInfo>();
        if (this.annotationScanRequired) {
            for (Map.Entry<String, String> entry : this.containerCreatedDynamicServletNameClassMap.entrySet()) {
                String servletName = entry.getKey();
                Collection urlPatterns2 = this.servletContext.getServletRegistration(servletName).getMappings();
                urlPatterns2.removeAll(this.webXmlConstraintUrlPatterns);
                if (this.dynamicServletNameSecurityElementMap.containsKey(servletName)) continue;
                this.processServletConstraintAnnotation(securityConstraints, servletName, entry.getValue(), urlPatterns2);
            }
        }
        for (Map.Entry<String, String> entry : this.dynamicServletNameSecurityElementMap.entrySet()) {
            urlPatterns = this.servletContext.getServletRegistration(entry.getKey()).getMappings();
            urlPatterns.removeAll(this.webXmlConstraintUrlPatterns);
            this.processServletSecurityElement(securityConstraints, (ServletSecurityElement)entry.getValue(), urlPatterns);
        }
        for (Map.Entry<Object, String> entry : this.registrationSecurityElementMap.entrySet()) {
            urlPatterns = ((RegistrationKey)entry.getKey()).registration.getMappings();
            urlPatterns.removeAll(this.webXmlConstraintUrlPatterns);
            this.processServletSecurityElement(securityConstraints, (ServletSecurityElement)entry.getValue(), urlPatterns);
        }
        this.webXmlAppInfo.securityConstraints.addAll(securityConstraints);
        return this.webXmlAppInfo;
    }

    public Set<String> setDynamicServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement constraint) {
        this.registrationSecurityElementMap.put(new RegistrationKey(registration), constraint);
        HashSet<String> uneffectedUrlPatterns = new HashSet<String>(registration.getMappings());
        uneffectedUrlPatterns.retainAll(this.webXmlConstraintUrlPatterns);
        return uneffectedUrlPatterns;
    }

    public Set<String> setDynamicServletSecurity(String servletName, ServletSecurityElement constraint, Collection<String> urlPatterns) {
        this.dynamicServletNameSecurityElementMap.put(servletName, constraint);
        HashSet<String> uneffectedUrlPatterns = new HashSet<String>(urlPatterns);
        uneffectedUrlPatterns.retainAll(this.webXmlConstraintUrlPatterns);
        return uneffectedUrlPatterns;
    }

    private void initialize() {
        for (SecurityConstraintInfo secuirtyConstraint : this.webXmlAppInfo.securityConstraints) {
            for (WebResourceCollectionInfo webResourceCollection : secuirtyConstraint.webResourceCollections) {
                this.webXmlConstraintUrlPatterns.addAll(webResourceCollection.urlPatterns);
            }
        }
    }

    private SecurityConstraintInfo newHTTPMethodSecurityConstraint(String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, String httpMethod, Collection<String> urlPatterns) {
        SecurityConstraintInfo securityConstraint = this.newSecurityConstraint(rolesAllowed, transportGuarantee, emptyRoleSemantic, true);
        WebResourceCollectionInfo webResourceCollection = securityConstraint.webResourceCollections.get(0);
        webResourceCollection.urlPatterns.addAll(urlPatterns);
        webResourceCollection.httpMethods.add(httpMethod);
        return securityConstraint;
    }

    private SecurityConstraintInfo newHTTPSecurityConstraint(String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, Collection<String> omissionMethods, Collection<String> urlPatterns) {
        SecurityConstraintInfo securityConstraint = this.newSecurityConstraint(rolesAllowed, transportGuarantee, emptyRoleSemantic, !omissionMethods.isEmpty());
        if (securityConstraint != null) {
            WebResourceCollectionInfo webResourceCollection = securityConstraint.webResourceCollections.get(0);
            webResourceCollection.httpMethods.addAll(omissionMethods);
            webResourceCollection.urlPatterns.addAll(urlPatterns);
            webResourceCollection.omission = true;
        }
        return securityConstraint;
    }

    private SecurityConstraintInfo newSecurityConstraint(String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, boolean force) {
        if (force || rolesAllowed.length > 0 || transportGuarantee.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL) || emptyRoleSemantic.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
            SecurityConstraintInfo securityConstraint = new SecurityConstraintInfo();
            WebResourceCollectionInfo webResourceCollection = new WebResourceCollectionInfo();
            securityConstraint.webResourceCollections.add(webResourceCollection);
            if (transportGuarantee.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL)) {
                securityConstraint.userDataConstraint = ServletSecurity.TransportGuarantee.CONFIDENTIAL.name();
            }
            if (emptyRoleSemantic.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                securityConstraint.authConstraint = new AuthConstraintInfo();
            } else if (rolesAllowed.length > 0) {
                AuthConstraintInfo authConstraint = new AuthConstraintInfo();
                for (String roleAllowed : rolesAllowed) {
                    authConstraint.roleNames.add(roleAllowed);
                }
                securityConstraint.authConstraint = authConstraint;
            }
            return securityConstraint;
        }
        return null;
    }

    private void processServletConstraintAnnotation(List<SecurityConstraintInfo> securityConstraints, String servletName, String servletClassName, Collection<String> urlPatterns) {
        try {
            Class cls = this.bundle.loadClass(servletClassName);
            if (!Servlet.class.isAssignableFrom(cls)) {
                return;
            }
            ServletSecurity servletSecurity = cls.getAnnotation(ServletSecurity.class);
            if (servletSecurity == null) {
                return;
            }
            if (urlPatterns.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No url pattern for the servlet class " + servletClassName + " is found in the deployment plan, SecurityConstraint annotation is ignored");
                }
                return;
            }
            this.processServletSecurityAnnotation(securityConstraints, servletSecurity, urlPatterns);
        }
        catch (ClassNotFoundException e) {
            logger.error("Fail to load class", (Throwable)e);
        }
    }

    private ServletSecurityElement processServletConstraintAnnotation(String servletClassName) {
        try {
            Class cls = this.bundle.loadClass(servletClassName);
            if (!Servlet.class.isAssignableFrom(cls)) {
                return null;
            }
            ServletSecurity servletSecurity = cls.getAnnotation(ServletSecurity.class);
            if (servletSecurity == null) {
                return null;
            }
            return new ServletSecurityElement(servletSecurity);
        }
        catch (ClassNotFoundException e) {
            logger.error("Fail to load class", (Throwable)e);
            return null;
        }
    }

    private void processServletSecurityAnnotation(List<SecurityConstraintInfo> securityConstraints, ServletSecurity servletSecurity, Collection<String> urlPatterns) {
        this.processServletSecurityElement(securityConstraints, new ServletSecurityElement(servletSecurity), urlPatterns);
    }

    private void processServletSecurityElement(List<SecurityConstraintInfo> securityConstraints, ServletSecurityElement servletSecurityElement, Collection<String> urlPatterns) {
        SecurityConstraintInfo securityConstraint;
        if (servletSecurityElement.getHttpMethodConstraints().size() > 0) {
            for (HttpMethodConstraintElement httpMethodConstraint : servletSecurityElement.getHttpMethodConstraints()) {
                SecurityConstraintInfo securityConstraint2 = this.newHTTPMethodSecurityConstraint(httpMethodConstraint.getRolesAllowed(), httpMethodConstraint.getTransportGuarantee(), httpMethodConstraint.getEmptyRoleSemantic(), httpMethodConstraint.getMethodName(), urlPatterns);
                if (securityConstraint2 != null) {
                    securityConstraints.add(securityConstraint2);
                }
                this.declareRoles(httpMethodConstraint.getRolesAllowed());
            }
        }
        if ((securityConstraint = this.newHTTPSecurityConstraint(servletSecurityElement.getRolesAllowed(), servletSecurityElement.getTransportGuarantee(), servletSecurityElement.getEmptyRoleSemantic(), servletSecurityElement.getMethodNames(), urlPatterns)) != null) {
            securityConstraints.add(securityConstraint);
        }
        this.declareRoles(servletSecurityElement.getRolesAllowed());
    }

    private static final class RegistrationKey {
        private final ServletRegistration.Dynamic registration;

        private RegistrationKey(ServletRegistration.Dynamic registration) {
            this.registration = registration;
        }

        public boolean equals(Object o) {
            return o instanceof RegistrationKey && this.registration.getName().equals(((RegistrationKey)o).registration.getName());
        }

        public int hashCode() {
            return this.registration.getName().hashCode();
        }
    }
}

