/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.info.SecurityConstraintInfo;
import org.apache.geronimo.web.info.SecurityRoleRefInfo;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web.info.WebResourceCollectionInfo;
import org.apache.geronimo.web.security.HTTPMethods;
import org.apache.geronimo.web.security.URLPattern;
import org.apache.geronimo.web.security.UncheckedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecSecurityBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpecSecurityBuilder.class);
    private final Set<String> securityRoles = new HashSet<String>();
    private final Map<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedResourcePatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedUserPatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<String, URLPattern> excludedPatterns = new HashMap<String, URLPattern>();
    private final Map<String, Map<String, URLPattern>> rolesPatterns = new HashMap<String, Map<String, URLPattern>>();
    private final Set<URLPattern> allSet = new HashSet<URLPattern>();
    private final Map<String, URLPattern> allMap = new HashMap<String, URLPattern>();
    private final RecordingPolicyConfiguration policyConfiguration = new RecordingPolicyConfiguration(true);
    private WebAppInfo webAppInfo;

    public SpecSecurityBuilder(WebAppInfo webAppInfo) {
        this.webAppInfo = webAppInfo;
    }

    public ComponentPermissions buildSpecSecurityConfig() {
        this.securityRoles.addAll(this.webAppInfo.securityRoles);
        try {
            for (ServletInfo servlet : this.webAppInfo.servlets) {
                this.processRoleRefPermissions(servlet);
            }
            this.addUnmappedJSPPermissions();
            this.analyzeSecurityConstraints(this.webAppInfo.securityConstraints);
            this.removeExcludedDups();
            return this.buildComponentPermissions();
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    private void analyzeSecurityConstraints(List<SecurityConstraintInfo> securityConstraints) {
        for (SecurityConstraintInfo securityConstraint : securityConstraints) {
            Map<String, URLPattern> currentPatterns = null;
            HashSet<String> roleNames = null;
            if (securityConstraint.authConstraint != null) {
                if (securityConstraint.authConstraint.roleNames.size() == 0) {
                    currentPatterns = this.excludedPatterns;
                } else {
                    roleNames = new HashSet<String>(securityConstraint.authConstraint.roleNames);
                    if (roleNames.remove("*")) {
                        roleNames.addAll(this.securityRoles);
                    }
                }
            } else {
                currentPatterns = this.uncheckedPatterns;
            }
            String transport = securityConstraint.userDataConstraint == null ? "NONE" : securityConstraint.userDataConstraint;
            boolean isRolebasedPatten = currentPatterns == null;
            for (WebResourceCollectionInfo webResourceCollection : securityConstraint.webResourceCollections) {
                for (String urlPattern : webResourceCollection.urlPatterns) {
                    if (isRolebasedPatten) {
                        for (String roleName : roleNames) {
                            Map<String, URLPattern> currentRolePatterns = this.rolesPatterns.get(roleName);
                            if (currentRolePatterns == null) {
                                currentRolePatterns = new HashMap<String, URLPattern>();
                                this.rolesPatterns.put(roleName, currentRolePatterns);
                            }
                            this.analyzeURLPattern(urlPattern, webResourceCollection.httpMethods, webResourceCollection.omission, transport, currentRolePatterns);
                        }
                    } else {
                        this.analyzeURLPattern(urlPattern, webResourceCollection.httpMethods, webResourceCollection.omission, transport, currentPatterns);
                    }
                    URLPattern allPattern = this.allMap.get(urlPattern);
                    if (allPattern == null) {
                        allPattern = new URLPattern(urlPattern, webResourceCollection.httpMethods, webResourceCollection.omission);
                        this.allSet.add(allPattern);
                        this.allMap.put(urlPattern, allPattern);
                        continue;
                    }
                    allPattern.addMethods(webResourceCollection.httpMethods, webResourceCollection.omission);
                }
            }
        }
    }

    private void analyzeURLPattern(String urlPattern, Set<String> httpMethods, boolean omission, String transport, Map<String, URLPattern> currentPatterns) {
        URLPattern pattern = currentPatterns.get(urlPattern);
        if (pattern == null) {
            pattern = new URLPattern(urlPattern, httpMethods, omission);
            currentPatterns.put(urlPattern, pattern);
        } else {
            pattern.addMethods(httpMethods, omission);
        }
        pattern.setTransport(transport);
    }

    private void removeExcludedDups() {
        for (Map.Entry<String, URLPattern> excluded : this.excludedPatterns.entrySet()) {
            String url = excluded.getKey();
            URLPattern pattern = excluded.getValue();
            this.removeExcluded(url, pattern, this.uncheckedPatterns);
            for (Map<String, URLPattern> rolePatterns : this.rolesPatterns.values()) {
                this.removeExcluded(url, pattern, rolePatterns);
            }
        }
    }

    private void removeExcluded(String url, URLPattern pattern, Map<String, URLPattern> patterns) {
        URLPattern testPattern = patterns.get(url);
        if (testPattern != null && !testPattern.removeMethods(pattern)) {
            patterns.remove(url);
        }
    }

    private ComponentPermissions buildComponentPermissions() throws PolicyContextException {
        HTTPMethods methods;
        String actions;
        String name;
        for (URLPattern uRLPattern : this.excludedPatterns.values()) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            actions = uRLPattern.getMethods();
            this.policyConfiguration.addToExcludedPolicy((Permission)new WebResourcePermission(name, actions));
            this.policyConfiguration.addToExcludedPolicy((Permission)new WebUserDataPermission(name, actions));
        }
        for (Map.Entry entry : this.rolesPatterns.entrySet()) {
            HashSet<URLPattern> currentRolePatterns = new HashSet<URLPattern>(((Map)entry.getValue()).values());
            for (URLPattern pattern : ((Map)entry.getValue()).values()) {
                String name2 = pattern.getQualifiedPattern(currentRolePatterns);
                String actions2 = pattern.getMethods();
                WebResourcePermission permission = new WebResourcePermission(name2, actions2);
                this.policyConfiguration.addToRole((String)entry.getKey(), (Permission)permission);
                HTTPMethods methods3 = pattern.getHTTPMethods();
                int transportType = pattern.getTransport();
                this.addOrUpdatePattern(this.uncheckedUserPatterns, name2, methods3, transportType);
            }
        }
        for (URLPattern uRLPattern : this.uncheckedPatterns.values()) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            HTTPMethods methods2 = uRLPattern.getHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            int transportType = uRLPattern.getTransport();
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, transportType);
        }
        for (URLPattern uRLPattern : this.allSet) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            HTTPMethods methods2 = uRLPattern.getComplementedHTTPMethods();
            if (methods2.isNone()) continue;
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, 0);
        }
        if (!this.allMap.containsKey("/")) {
            URLPattern pattern = new URLPattern("/", Collections.<String>emptySet(), false);
            String string = pattern.getQualifiedPattern(this.allSet);
            methods = pattern.getComplementedHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, string, methods, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, string, methods, 0);
        }
        for (UncheckedItem uncheckedItem : this.uncheckedResourcePatterns.keySet()) {
            methods = this.uncheckedResourcePatterns.get(uncheckedItem);
            actions = URLPattern.getMethodsWithTransport(methods, uncheckedItem.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebResourcePermission(uncheckedItem.getName(), actions));
        }
        for (UncheckedItem uncheckedItem : this.uncheckedUserPatterns.keySet()) {
            methods = this.uncheckedUserPatterns.get(uncheckedItem);
            actions = URLPattern.getMethodsWithTransport(methods, uncheckedItem.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebUserDataPermission(uncheckedItem.getName(), actions));
        }
        return this.policyConfiguration.getComponentPermissions();
    }

    private void addOrUpdatePattern(Map<UncheckedItem, HTTPMethods> patternMap, String name, HTTPMethods actions, int transportType) {
        UncheckedItem item = new UncheckedItem(name, transportType);
        HTTPMethods existingActions = patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, existingActions.add(actions));
        } else {
            patternMap.put(item, new HTTPMethods(actions, false));
        }
    }

    protected void processRoleRefPermissions(ServletInfo servlet) throws PolicyContextException {
        String servletName = servlet.servletName.trim();
        HashSet<String> unmappedRoles = new HashSet<String>(this.securityRoles);
        for (SecurityRoleRefInfo securityRoleRef : servlet.securityRoleRefs) {
            this.policyConfiguration.addToRole(securityRoleRef.roleLink, (Permission)new WebRoleRefPermission(servletName, securityRoleRef.roleName));
            unmappedRoles.remove(securityRoleRef.roleName);
        }
        for (String roleName : unmappedRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName));
        }
    }

    protected void addUnmappedJSPPermissions() throws PolicyContextException {
        for (String roleName : this.securityRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission("", roleName));
        }
    }

    public void clear() {
        this.securityRoles.clear();
        this.uncheckedPatterns.clear();
        this.uncheckedResourcePatterns.clear();
        this.uncheckedUserPatterns.clear();
        this.excludedPatterns.clear();
        this.rolesPatterns.clear();
        this.allSet.clear();
        this.allMap.clear();
    }

    private static class RecordingPolicyConfiguration
    implements PolicyConfiguration {
        private final PermissionCollection excludedPermissions = new Permissions();
        private final PermissionCollection uncheckedPermissions = new Permissions();
        private final Map<String, PermissionCollection> rolePermissions = new HashMap<String, PermissionCollection>();
        private final StringBuilder audit;

        private RecordingPolicyConfiguration(boolean audit) {
            this.audit = audit ? new StringBuilder() : null;
        }

        public String getContextID() throws PolicyContextException {
            return null;
        }

        public void addToRole(String roleName, PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToRole(String roleName, Permission permission) throws PolicyContextException {
            PermissionCollection permissionsForRole;
            if (this.audit != null) {
                this.audit.append("Role: ").append(roleName).append(" -> ").append(permission).append('\n');
            }
            if ((permissionsForRole = this.rolePermissions.get(roleName)) == null) {
                permissionsForRole = new Permissions();
                this.rolePermissions.put(roleName, permissionsForRole);
            }
            permissionsForRole.add(permission);
        }

        public void addToUncheckedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Unchecked -> ").append(permission).append('\n');
            }
            this.uncheckedPermissions.add(permission);
        }

        public void addToExcludedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Excluded -> ").append(permission).append('\n');
            }
            this.excludedPermissions.add(permission);
        }

        public void removeRole(String roleName) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeUncheckedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeExcludedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void delete() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void commit() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public boolean inService() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public ComponentPermissions getComponentPermissions() {
            return new ComponentPermissions(this.excludedPermissions, this.uncheckedPermissions, this.rolePermissions);
        }

        public String getAudit() {
            if (this.audit == null) {
                return "no audit kept";
            }
            return this.audit.toString();
        }
    }
}

