/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletLoadOnStartupMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ServletMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    private List<SubMergeHandler<Servlet, Servlet>> subMergeHandlers = new ArrayList<SubMergeHandler<Servlet, Servlet>>(2);

    public ServletMergeHandler() {
        this.subMergeHandlers.add(new ServletInitParamMergeHandler());
        this.subMergeHandlers.add(new ServletLoadOnStartupMergeHandler());
    }

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Servlet srcServlet : webFragment.getServlet()) {
            String servletName = srcServlet.getServletName();
            Servlet targetServlet = (Servlet)mergeContext.getAttribute(ServletMergeHandler.createServletKey(servletName));
            if (targetServlet == null) {
                webApp.getServlet().add(srcServlet);
                mergeContext.setAttribute(ServletMergeHandler.createServletKey(servletName), srcServlet);
                for (SubMergeHandler<Servlet, Servlet> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(srcServlet, mergeContext);
                }
                continue;
            }
            for (SubMergeHandler<Servlet, Servlet> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcServlet, targetServlet, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (SubMergeHandler<Servlet, Servlet> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, mergeContext);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Servlet servlet : webApp.getServlet()) {
            mergeContext.setAttribute(ServletMergeHandler.createServletKey(servlet.getServletName()), servlet);
        }
        for (SubMergeHandler subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
    }

    public static String createServletKey(String servletName) {
        return "servlet.servlet-name." + servletName;
    }

    public static boolean isServletConfigured(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletMergeHandler.createServletKey(servletName));
    }

    public static Servlet getServlet(String servletName, MergeContext mergeContext) {
        return (Servlet)mergeContext.getAttribute(ServletMergeHandler.createServletKey(servletName));
    }

    public static void addServlet(Servlet servlet, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletMergeHandler.createServletKey(servlet.getServletName()), servlet);
    }
}

