/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.WebApp;

public class ServletMappingUrlPatternMergeHandler
implements SubMergeHandler<ServletMapping, ServletMapping> {
    @Override
    public void add(ServletMapping servletMapping, MergeContext mergeContext) throws DeploymentException {
        String servletName = servletMapping.getServletName();
        for (String urlPattern : servletMapping.getUrlPattern()) {
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPattern), urlPattern);
        }
    }

    @Override
    public void merge(ServletMapping srcServletMapping, ServletMapping targetServletMapping, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServletMapping.getServletName();
        for (String urlPattern : srcServletMapping.getUrlPattern()) {
            String servletMappingUrlPatternKey = ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPattern);
            if (mergeContext.containsAttribute(servletMappingUrlPatternKey)) continue;
            targetServletMapping.getUrlPattern().add(urlPattern);
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(servletMappingUrlPatternKey, urlPattern);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            String servletName = servletMapping.getServletName();
            for (String urlPattern : servletMapping.getUrlPattern()) {
                if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPattern, "web.xml"));
                }
                context.setAttribute(ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPattern), urlPattern);
            }
        }
    }

    public static String createServletMappingUrlPatternKey(String servletName, String urlPattern) {
        return "servlet-mapping.servlet-name." + servletName + ".url-pattern." + urlPattern;
    }
}

