/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ResourceRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String RESOURCE_REF_NAME_PREFIX = "resource-ref.res-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceRef srcResourceRef : webFragment.getResourceRef()) {
            String resourceRefName = srcResourceRef.getResRefName();
            String resourceRefKey = ResourceRefMergeHandler.createResourceRefKey(resourceRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(resourceRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("resource-ref", resourceRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ResourceRefMergeHandler.isResourceRefInjectTargetsConfiguredInInitialWebXML(resourceRefName, mergeContext)) continue;
                ResourceRef resourceRef = (ResourceRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcResourceRef.getInjectionTarget()) {
                    String resourceRefInjectTargetKey = ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(resourceRefInjectTargetKey)) continue;
                    resourceRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(resourceRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getResourceRef().add(srcResourceRef);
            mergeContext.setAttribute(resourceRefKey, new MergeItem(srcResourceRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcResourceRef.getInjectionTarget()) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceRef resourceRef : webApp.getResourceRef()) {
            String resourceRefName = resourceRef.getResRefName();
            mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefKey(resourceRefName), new MergeItem(resourceRef, null, ElementSource.WEB_XML));
            if (!resourceRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetConfiguredInWebXMLKey(resourceRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : resourceRef.getInjectionTarget()) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createResourceRefInjectTargetConfiguredInWebXMLKey(String resourceRefName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createResourceRefInjectTargetKey(String resourceRefName, String injectTargetClassName, String injectTargetName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createResourceRefKey(String resourceRefName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName;
    }

    public static boolean isResourceRefInjectTargetConfigured(String resourceRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isResourceRefInjectTargetsConfiguredInInitialWebXML(String resourceRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetConfiguredInWebXMLKey(resourceRefName));
    }
}

