/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import javax.servlet.DispatcherType;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMergeHandler;
import org.apache.openejb.jee.Dispatcher;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.WebApp;

public class WebFilterAnnotationMergeHandler
implements AnnotationMergeHandler {
    @Override
    public void merge(Class<?>[] classes, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            String[] urlPatterns;
            boolean servletNamesAttributeConfigured;
            boolean urlPatternsAttributeConfigured;
            if (!javax.servlet.Filter.class.isAssignableFrom(cls)) {
                throw new DeploymentException("The class " + cls.getName() + " with WebFilter annotation must implement javax.servlet.Filter");
            }
            WebFilter webFilter = cls.getAnnotation(WebFilter.class);
            String filterName = webFilter.filterName().length() == 0 ? cls.getName() : webFilter.filterName();
            boolean valueAttributeConfigured = webFilter.value().length > 0;
            boolean bl = urlPatternsAttributeConfigured = webFilter.urlPatterns().length > 0;
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                throw new DeploymentException("value and urlPatterns must not be configured on the same WebFilter annotation in the class " + cls.getName());
            }
            boolean bl2 = servletNamesAttributeConfigured = webFilter.servletNames().length == 0;
            if (!(valueAttributeConfigured || urlPatternsAttributeConfigured || servletNamesAttributeConfigured)) {
                throw new DeploymentException("At least one of value, urlPatterns and servletNames attributes are configured on the WebFilter annotation in the class " + cls.getName());
            }
            String[] stringArray = urlPatterns = valueAttributeConfigured ? webFilter.value() : webFilter.urlPatterns();
            if (FilterMergeHandler.isFilterConfigured(filterName, mergeContext)) {
                Filter targetFilter = FilterMergeHandler.getFilter(filterName, mergeContext);
                for (WebInitParam webInitParam : webFilter.initParams()) {
                    String paramName = webInitParam.name();
                    if (FilterInitParamMergeHandler.isFilterInitParamConfigured(filterName, paramName, mergeContext)) continue;
                    ParamValue newParamValue = WebFilterAnnotationMergeHandler.newParamValue(webInitParam);
                    targetFilter.getInitParam().add(newParamValue);
                    FilterInitParamMergeHandler.addFilterInitParam(filterName, newParamValue, ElementSource.ANNOTATION, mergeContext.getCurrentJarUrl(), mergeContext);
                }
            } else {
                Filter newFilter = new Filter();
                webApp.getFilter().add(newFilter);
                newFilter.setFilterName(filterName);
                newFilter.setAsyncSupported(webFilter.asyncSupported());
                if (!webFilter.description().isEmpty()) {
                    newFilter.addDescription(new Text(null, webFilter.description()));
                }
                if (!webFilter.displayName().isEmpty()) {
                    newFilter.addDisplayName(new Text(null, webFilter.displayName()));
                }
                newFilter.setFilterClass(cls.getName());
                for (WebInitParam webInitParam : webFilter.initParams()) {
                    newFilter.getInitParam().add(WebFilterAnnotationMergeHandler.newParamValue(webInitParam));
                }
                if (!webFilter.smallIcon().isEmpty() || !webFilter.largeIcon().isEmpty()) {
                    Icon icon = new Icon();
                    if (!webFilter.smallIcon().isEmpty()) {
                        icon.setSmallIcon(webFilter.smallIcon());
                    }
                    if (!webFilter.largeIcon().isEmpty()) {
                        icon.setLargeIcon(webFilter.largeIcon());
                    }
                    newFilter.getIconMap().put(null, icon);
                }
                FilterMergeHandler.addFilter(newFilter, mergeContext);
            }
            if (FilterMappingMergeHandler.isFilterMappingConfigured(filterName, mergeContext)) continue;
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.setFilterName(filterName);
            for (String string : webFilter.servletNames()) {
                filterMapping.getServletName().add(string);
            }
            for (DispatcherType dispatcherType : webFilter.dispatcherTypes()) {
                filterMapping.getDispatcher().add(Dispatcher.fromValue((String)dispatcherType.name()));
            }
            for (String string : urlPatterns) {
                filterMapping.getUrlPattern().add(string);
            }
            webApp.getFilterMapping().add(filterMapping);
            FilterMappingMergeHandler.addFilterMapping(filterMapping, mergeContext);
            mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName), (Object)ElementSource.ANNOTATION);
        }
    }

    public static ParamValue newParamValue(WebInitParam webInitParam) {
        ParamValue newParamValue = new ParamValue();
        newParamValue.addDescription(new Text(null, webInitParam.description()));
        newParamValue.setParamName(webInitParam.name());
        newParamValue.setParamValue(webInitParam.value());
        return newParamValue;
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

