/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.ResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ResourceEnvRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String RESOURCE_ENV_REF_NAME_PREFIX = "resource-env-ref.resource-env-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceEnvRefType srcResourceEnvRef : webFragment.getResourceEnvRefArray()) {
            String resourceEnvRefName = srcResourceEnvRef.getResourceEnvRefName().getStringValue();
            String resourceEnvRefKey = ResourceEnvRefMergeHandler.createResourceEnvRefKey(resourceEnvRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(resourceEnvRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("resource-env-ref", resourceEnvRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ResourceEnvRefMergeHandler.isResourceEnvRefInjectTargetsConfiguredInInitialWebXML(resourceEnvRefName, mergeContext)) continue;
                ResourceEnvRefType resourceEnvRef = (ResourceEnvRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcResourceEnvRef.getInjectionTargetArray()) {
                    String resourceEnvRefInjectTargetKey = ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(resourceEnvRefInjectTargetKey)) continue;
                    resourceEnvRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(resourceEnvRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            ResourceEnvRefType targetResourceEnvRef = (ResourceEnvRefType)webApp.addNewResourceEnvRef().set((XmlObject)srcResourceEnvRef);
            mergeContext.setAttribute(resourceEnvRefKey, new MergeItem(targetResourceEnvRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetResourceEnvRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceEnvRefType resourceEnvRef : webApp.getResourceEnvRefArray()) {
            String resourceEnvRefName = resourceEnvRef.getResourceEnvRefName().getStringValue();
            mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefKey(resourceEnvRefName), new MergeItem(resourceEnvRef, null, ElementSource.WEB_XML));
            if (resourceEnvRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetConfiguredInWebXMLKey(resourceEnvRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : resourceEnvRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createResourceEnvRefInjectTargetConfiguredInWebXMLKey(String resourceEnvRefName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createResourceEnvRefInjectTargetKey(String resourceEnvRefName, String injectTargetClassName, String injectTargetName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createResourceEnvRefKey(String resourceEnvRefName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName;
    }

    public static boolean isResourceEnvRefInjectTargetConfigured(String resourceEnvRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isResourceEnvRefInjectTargetsConfiguredInInitialWebXML(String resourceEnvRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetConfiguredInWebXMLKey(resourceEnvRefName));
    }
}

