/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.FilterType;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xmlbeans.XmlObject;

public class FilterInitParamMergeHandler
implements SubMergeHandler<FilterType, FilterType> {
    @Override
    public void add(FilterType servlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = servlet.getFilterName().getStringValue();
        for (ParamValueType paramValue : servlet.getInitParamArray()) {
            FilterInitParamMergeHandler.addFilterInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
        }
    }

    @Override
    public void merge(FilterType srcFilter, FilterType targetFilter, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilter.getFilterName().getStringValue();
        block5: for (ParamValueType paramValue : srcFilter.getInitParamArray()) {
            MergeItem existedMergeItem = (MergeItem)mergeContext.getAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramValue.getParamName().getStringValue()));
            if (existedMergeItem == null) {
                targetFilter.addNewInitParam().set((XmlObject)paramValue);
                FilterInitParamMergeHandler.addFilterInitParam(filterName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
                continue;
            }
            ParamValueType existedParamValue = (ParamValueType)existedMergeItem.getValue();
            switch (existedMergeItem.getSourceType()) {
                case WEB_XML: {
                    continue block5;
                }
                case WEB_FRAGMENT: {
                    if (existedParamValue.getParamValue().getStringValue().equals(paramValue.getParamValue().getStringValue()) || existedMergeItem.getBelongedURL().equals(mergeContext.getCurrentJarUrl())) continue block5;
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("filter " + filterName, "param-name", paramValue.getParamName().getStringValue(), "param-value", existedParamValue.getParamValue().getStringValue(), existedMergeItem.getBelongedURL(), paramValue.getParamValue().getStringValue(), mergeContext.getCurrentJarUrl()));
                }
                case ANNOTATION: {
                    existedParamValue.getParamValue().set((XmlObject)paramValue.getParamValue());
                    existedMergeItem.setBelongedURL(mergeContext.getCurrentJarUrl());
                    existedMergeItem.setSourceType(ElementSource.WEB_FRAGMENT);
                }
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (FilterType filter : webApp.getFilterArray()) {
            String filterName = filter.getFilterName().getStringValue();
            for (ParamValueType paramValue : filter.getInitParamArray()) {
                FilterInitParamMergeHandler.addFilterInitParam(filterName, paramValue, ElementSource.WEB_XML, null, context);
            }
        }
    }

    public static String createFilterInitParamKey(String filterName, String paramName) {
        return "filter." + filterName + ".init-param.param-name." + paramName;
    }

    public static boolean isFilterInitParamConfigured(String filterName, String paramName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramName));
    }

    public static void addFilterInitParam(String filterName, ParamValueType paramValue, ElementSource source, String relativeUrl, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramValue.getParamName().getStringValue()), new MergeItem(paramValue, relativeUrl, source));
    }
}

