/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;

public class DistributableMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String CURRENT_MERGED_DISTRIBUTABLE_VALUE = "CURRENT_MERGED_DISTRIBUTABLE_VALUE";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        boolean currentMergedDistributableValue = (Boolean)mergeContext.getAttribute(CURRENT_MERGED_DISTRIBUTABLE_VALUE);
        if (currentMergedDistributableValue) {
            mergeContext.setAttribute(CURRENT_MERGED_DISTRIBUTABLE_VALUE, webFragment.getDistributableArray().length > 0);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        boolean distributableInWebXml;
        boolean currentMergedDistributableValue = (Boolean)mergeContext.getAttribute(CURRENT_MERGED_DISTRIBUTABLE_VALUE);
        boolean bl = distributableInWebXml = webApp.getDistributableArray().length > 0;
        if (currentMergedDistributableValue) {
            if (!distributableInWebXml) {
                webApp.addNewDistributable();
            }
        } else if (distributableInWebXml) {
            int iLoopSize = webApp.getDistributableArray().length;
            for (int i = 0; i < iLoopSize; ++i) {
                webApp.removeDistributable(0);
            }
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        context.setAttribute(CURRENT_MERGED_DISTRIBUTABLE_VALUE, Boolean.TRUE);
    }
}

