/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ContextParamMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String QUALIFIED_CONTEXT_PARAM_NAME_PREFIX = "context-param.param-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        String jarUrl = mergeContext.getCurrentJarUrl();
        for (ParamValueType paramValue : webFragment.getContextParamArray()) {
            String qualifiedContextParamName = QUALIFIED_CONTEXT_PARAM_NAME_PREFIX + paramValue.getParamName().getStringValue();
            if (mergeContext.containsAttribute(qualifiedContextParamName)) continue;
            MergeItem existedContextParamValue = (MergeItem)mergeContext.getAttribute(qualifiedContextParamName);
            if (existedContextParamValue == null) {
                webApp.addNewContextParam().set((XmlObject)paramValue);
                mergeContext.setAttribute(qualifiedContextParamName, new MergeItem(paramValue.getParamValue().getStringValue(), jarUrl, ElementSource.WEB_FRAGMENT));
                continue;
            }
            if (existedContextParamValue.getValue().equals(paramValue.getParamValue().getStringValue())) continue;
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("context-param", "param-name", paramValue.getParamName().getStringValue(), "param-value", existedContextParamValue.getValue().toString(), existedContextParamValue.getBelongedURL(), paramValue.getParamValue().getStringValue(), jarUrl));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ParamValueType paramValue : webApp.getContextParamArray()) {
            context.setAttribute(QUALIFIED_CONTEXT_PARAM_NAME_PREFIX + paramValue.getParamName().getStringValue(), paramValue.getParamName().getStringValue());
        }
    }
}

