/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import java.util.Arrays;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ListenerMergeHandler;
import org.apache.geronimo.xbeans.javaee6.ListenerType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;

public class WebListenerAnnotationMergeHandler
implements AnnotationMergeHandler {
    public static final Class<?>[] SUPPORTED_WEBLISTENER_INTERFACES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class, AsyncListener.class};

    @Override
    public void merge(Class<?>[] classes, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            Class<?> implementedWebListenerInterface = null;
            for (Class<?> supportedWebListenerInterface : SUPPORTED_WEBLISTENER_INTERFACES) {
                if (!supportedWebListenerInterface.isAssignableFrom(cls)) continue;
                implementedWebListenerInterface = supportedWebListenerInterface;
                break;
            }
            if (implementedWebListenerInterface == null) {
                throw new DeploymentException("One of supported web listener interface " + Arrays.toString(SUPPORTED_WEBLISTENER_INTERFACES) + " should  be implemented by class " + cls.getName() + " while WebListener annotation is used");
            }
            WebListener webListener = cls.getAnnotation(WebListener.class);
            if (ListenerMergeHandler.isListenerConfigured(cls.getName(), mergeContext)) {
                return;
            }
            ListenerType newListener = webApp.addNewListener();
            if (!webListener.value().isEmpty()) {
                newListener.addNewDescription().setStringValue(webListener.value());
            }
            newListener.addNewListenerClass().setStringValue(cls.getName());
            ListenerMergeHandler.addListener(newListener, mergeContext);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

