/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMergeHandler;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.FilterType;
import org.apache.geronimo.xbeans.javaee6.IconType;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;

public class WebFilterAnnotationMergeHandler
implements AnnotationMergeHandler {
    @Override
    public void merge(Class<?>[] classes, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            String[] urlPatterns;
            boolean servletNamesAttributeConfigured;
            boolean urlPatternsAttributeConfigured;
            if (!Filter.class.isAssignableFrom(cls)) {
                throw new DeploymentException("The class " + cls.getName() + " with WebFilter annotation must implement javax.servlet.Filter");
            }
            WebFilter webFilter = cls.getAnnotation(WebFilter.class);
            String filterName = webFilter.filterName().length() == 0 ? cls.getName() : webFilter.filterName();
            boolean valueAttributeConfigured = webFilter.value().length > 0;
            boolean bl = urlPatternsAttributeConfigured = webFilter.urlPatterns().length > 0;
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                throw new DeploymentException("value and urlPatterns must not be configured on the same WebFilter annotation in the class " + cls.getName());
            }
            boolean bl2 = servletNamesAttributeConfigured = webFilter.servletNames().length == 0;
            if (!(valueAttributeConfigured || urlPatternsAttributeConfigured || servletNamesAttributeConfigured)) {
                throw new DeploymentException("At least one of value, urlPatterns and servletNames attributes are configured on the WebFilter annotation in the class " + cls.getName());
            }
            String[] stringArray = urlPatterns = valueAttributeConfigured ? webFilter.value() : webFilter.urlPatterns();
            if (FilterMergeHandler.isFilterConfigured(filterName, mergeContext)) {
                FilterType targetFilter = FilterMergeHandler.getFilter(filterName, mergeContext);
                for (WebInitParam webInitParam : webFilter.initParams()) {
                    String paramName = webInitParam.name();
                    if (FilterInitParamMergeHandler.isFilterInitParamConfigured(filterName, paramName, mergeContext)) continue;
                    ParamValueType newParamValue = targetFilter.addNewInitParam();
                    newParamValue.addNewDescription().setStringValue(webInitParam.description());
                    newParamValue.addNewParamName().setStringValue(webInitParam.name());
                    newParamValue.addNewParamValue().setStringValue(webInitParam.value());
                    FilterInitParamMergeHandler.addFilterInitParam(filterName, newParamValue, ElementSource.ANNOTATION, mergeContext.getCurrentJarUrl(), mergeContext);
                }
            } else {
                FilterType newFilter = webApp.addNewFilter();
                newFilter.addNewFilterName().setStringValue(filterName);
                newFilter.addNewAsyncSupported().setBooleanValue(webFilter.asyncSupported());
                if (!webFilter.description().isEmpty()) {
                    newFilter.addNewDescription().setStringValue(webFilter.description());
                }
                if (!webFilter.displayName().isEmpty()) {
                    newFilter.addNewDisplayName().setStringValue(webFilter.displayName());
                }
                newFilter.addNewFilterClass().setStringValue(cls.getName());
                for (WebInitParam webInitParam : webFilter.initParams()) {
                    ParamValueType paramValue = newFilter.addNewInitParam();
                    paramValue.addNewDescription().setStringValue(webInitParam.description());
                    paramValue.addNewParamName().setStringValue(webInitParam.name());
                    paramValue.addNewParamValue().setStringValue(webInitParam.value());
                }
                if (!webFilter.smallIcon().isEmpty() || !webFilter.largeIcon().isEmpty()) {
                    IconType iconType = newFilter.addNewIcon();
                    if (!webFilter.smallIcon().isEmpty()) {
                        iconType.addNewSmallIcon().setStringValue(webFilter.smallIcon());
                    }
                    if (!webFilter.largeIcon().isEmpty()) {
                        iconType.addNewLargeIcon().setStringValue(webFilter.largeIcon());
                    }
                }
                FilterMergeHandler.addFilter(newFilter, mergeContext);
            }
            if (FilterMappingMergeHandler.isFilterMappingConfigured(filterName, mergeContext)) continue;
            FilterMappingType filterMapping = webApp.addNewFilterMapping();
            filterMapping.addNewFilterName().setStringValue(filterName);
            for (String string : webFilter.servletNames()) {
                filterMapping.addNewServletName().setStringValue(string);
            }
            for (DispatcherType dispatcherType : webFilter.dispatcherTypes()) {
                filterMapping.addNewDispatcher().setStringValue(dispatcherType.name());
            }
            for (String string : urlPatterns) {
                filterMapping.addNewUrlPattern().setStringValue(string);
            }
            FilterMappingMergeHandler.addFilterMapping(filterMapping, mergeContext);
            mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName), (Object)ElementSource.ANNOTATION);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

