/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.components.jaspi.model.AuthModuleType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.JaspiXmlUtil;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.SecurityAnnotationHelper;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.j2ee.jndi.WebContextSource;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jaspi.AuthConfigProviderGBean;
import org.apache.geronimo.security.jaspi.ServerAuthConfigGBean;
import org.apache.geronimo.security.jaspi.ServerAuthContextGBean;
import org.apache.geronimo.security.jaspi.ServerAuthModuleGBean;
import org.apache.geronimo.web.security.SpecSecurityBuilder;
import org.apache.geronimo.web25.deployment.merge.MergeHelper;
import org.apache.geronimo.web25.deployment.security.AuthenticationWrapper;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.javaee6.FilterType;
import org.apache.geronimo.xbeans.javaee6.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee6.ListenerType;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractWebModuleBuilder
implements ModuleBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebModuleBuilder.class);
    protected static final boolean COMBINED_BUNDLE = true;
    public static final EARContext.Key<GBeanData> DEFAULT_JSP_SERVLET_KEY = new EARContext.Key<GBeanData>(){

        public GBeanData get(Map<EARContext.Key, Object> context) {
            return (GBeanData)context.get(this);
        }
    };
    public static final EARContext.Key<Boolean> WEB_MODULE_HAS_SECURITY_REALM = new EARContext.Key<Boolean>(){

        public Boolean get(Map<EARContext.Key, Object> context) {
            return (Boolean)context.get(this);
        }
    };
    public static final EARContext.Key<Set<String>> EXCLUDED_JAR_URLS = new EARContext.Key<Set<String>>(){

        public Set<String> get(Map<EARContext.Key, Object> context) {
            HashSet excludedJarUrls = (HashSet)context.get(this);
            if (excludedJarUrls == null) {
                excludedJarUrls = new HashSet();
                context.put(this, excludedJarUrls);
            }
            return excludedJarUrls;
        }
    };
    public static final EARContext.Key<Map<String, Set<String>>> SERVLET_CONTAINER_INITIALIZERS = new EARContext.Key<Map<String, Set<String>>>(){

        public Map<String, Set<String>> get(Map<EARContext.Key, Object> context) {
            return (Map)context.get(this);
        }
    };
    public static final EARContext.Key<Float> INITIAL_WEB_XML_SCHEMA_VERSION = new EARContext.Key<Float>(){

        public Float get(Map<EARContext.Key, Object> context) {
            return (Float)context.get(this);
        }
    };
    public static final EARContext.Key<List<String>> ORDERED_LIBS = new EARContext.Key<List<String>>(){

        public List<String> get(Map<EARContext.Key, Object> context) {
            return (List)context.get(this);
        }
    };
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected static final AbstractNameQuery MANAGED_CONNECTION_FACTORY_PATTERN;
    private static final AbstractNameQuery ADMIN_OBJECT_PATTERN;
    protected static final AbstractNameQuery STATELESS_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery STATEFUL_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery ENTITY_BEAN_PATTERN;
    protected final Kernel kernel;
    protected final NamespaceDrivenBuilderCollection serviceBuilders;
    protected final ResourceEnvironmentSetter resourceEnvironmentSetter;
    protected final Collection<WebServiceBuilder> webServiceBuilder;
    protected final NamingBuilder namingBuilders;
    protected final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private static final QName SECURITY_QNAME;
    private static final URI RELATIVE_MODULE_BASE_URI;
    public static final String MESSAGE_LAYER = "HttpServlet";

    protected AbstractWebModuleBuilder(Kernel kernel, Collection<NamespaceDrivenBuilder> serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter, Collection<WebServiceBuilder> webServiceBuilder, Collection<ModuleBuilderExtension> moduleBuilderExtensions) {
        this.kernel = kernel;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders);
        this.namingBuilders = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        this.webServiceBuilder = webServiceBuilder;
        this.moduleBuilderExtensions = moduleBuilderExtensions == null ? new ArrayList() : moduleBuilderExtensions;
    }

    public NamingBuilder getNamingBuilders() {
        return this.namingBuilders;
    }

    protected void addGBeanDependencies(EARContext earContext, GBeanData webModuleData) {
        Configuration earConfiguration = earContext.getConfiguration();
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, MANAGED_CONNECTION_FACTORY_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ADMIN_OBJECT_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATELESS_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATEFUL_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ENTITY_BEAN_PATTERN), webModuleData);
    }

    private void addDependencies(LinkedHashSet<GBeanData> dependencies, GBeanData webModuleData) {
        for (GBeanData dependency : dependencies) {
            AbstractName dependencyName = dependency.getAbstractName();
            webModuleData.addDependency(dependencyName);
        }
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, ".", null, null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, (String)moduleContextInfo, earName, naming, idBuilder);
    }

    protected abstract Module createModule(Object var1, JarFile var2, String var3, URL var4, Environment var5, String var6, AbstractName var7, Naming var8, ModuleIDBuilder var9) throws DeploymentException;

    protected Map<String, String> buildServletNameToPathMap(WebAppType webApp, String contextRoot) {
        ServletMappingType[] servletMappings;
        if (contextRoot == null) {
            contextRoot = "";
        } else if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            String servletName = servletMapping.getServletName().getStringValue().trim();
            UrlPatternType[] urlPatterns = servletMapping.getUrlPatternArray();
            for (int i = 0; urlPatterns != null && i < urlPatterns.length; ++i) {
                map.put(servletName, contextRoot + urlPatterns[i].getStringValue().trim());
            }
        }
        return map;
    }

    protected String determineDefaultContextRoot(WebAppType webApp, boolean isStandAlone, JarFile moduleFile, String targetPath) {
        if (webApp != null && webApp.getId() != null) {
            return webApp.getId();
        }
        if (isStandAlone) {
            return "/" + this.trimPath(new File(moduleFile.getName()).getName());
        }
        return this.trimPath(targetPath);
    }

    private String trimPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".war")) {
            path = path.substring(0, path.length() - 4);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String getModuleName(WebAppType webApp) {
        if (webApp.sizeOfModuleNameArray() > 0) {
            return webApp.getModuleNameArray()[0].getStringValue().trim();
        }
        return null;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext moduleContext = earContext;
        module.setEarContext(moduleContext);
        module.setRootEarContext(earContext);
        try {
            ClassPathList manifestcp = new ClassPathList();
            JarFile warFile = module.getModuleFile();
            Enumeration<JarEntry> entries = warFile.entries();
            ArrayList<ZipEntry> libs = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI targetPath = module.resolve(entry.getName());
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    moduleContext.addFile(targetPath, module.getOriginalSpecDD());
                    continue;
                }
                if (entry.getName().startsWith("WEB-INF/lib") && entry.getName().endsWith(".jar")) {
                    libs.add(entry);
                    continue;
                }
                moduleContext.addFile(targetPath, (ZipFile)warFile, entry);
            }
            moduleContext.addToClassPath(module.resolve("WEB-INF/classes/").getPath());
            manifestcp.add((Object)"WEB-INF/classes/");
            for (ZipEntry entry : libs) {
                URI targetPath = module.resolve(entry.getName());
                moduleContext.addInclude(targetPath, (ZipFile)warFile, entry);
                manifestcp.add((Object)entry.getName());
            }
            moduleContext.addManifestClassPath(warFile, RELATIVE_MODULE_BASE_URI);
            moduleContext.getGeneralData().put(EARContext.CLASS_PATH_LIST_KEY, manifestcp);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying war", (Throwable)e);
        }
        finally {
            if (!module.isStandAlone()) {
                try {
                    moduleContext.flush();
                }
                catch (IOException e) {
                    throw new DeploymentException("Problem closing war context", (Throwable)e);
                }
            }
        }
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repositories);
        }
    }

    protected abstract void preInitContext(EARContext var1, Module var2, Bundle var3) throws DeploymentException;

    protected abstract void postInitContext(EARContext var1, Module var2, Bundle var3) throws DeploymentException;

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        this.preInitContext(earContext, module, bundle);
        this.basicInitContext(earContext, module, bundle, (XmlObject)module.getVendorDD());
        this.postInitContext(earContext, module, bundle);
    }

    protected void basicInitContext(EARContext earContext, Module module, Bundle bundle, XmlObject gerWebApp) throws DeploymentException {
        XmlObject[] securityElements;
        WebModule webModule = (WebModule)module;
        EARContext moduleContext = webModule.getEarContext();
        ClassPathList manifestcp = (ClassPathList)EARContext.CLASS_PATH_LIST_KEY.get(moduleContext.getGeneralData());
        ModuleList moduleLocations = (ModuleList)EARContext.MODULE_LIST_KEY.get(webModule.getRootEarContext().getGeneralData());
        URI baseUri = URI.create(webModule.getTargetPath());
        URI resolutionUri = AbstractWebModuleBuilder.invertURI(baseUri);
        earContext.getCompleteManifestClassPath(webModule.getDeployable(), baseUri, resolutionUri, manifestcp, moduleLocations);
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        boolean hasSecurityRealmName = (Boolean)module.getEarContext().getGeneralData().get(WEB_MODULE_HAS_SECURITY_REALM);
        if (!(webApp.getSecurityConstraintArray().length <= 0 && webApp.getSecurityRoleArray().length <= 0 || hasSecurityRealmName)) {
            throw new DeploymentException("web.xml for web app " + webModule.getName() + " includes security elements but Geronimo deployment plan is not provided or does not contain <security-realm-name> element necessary to configure security accordingly.");
        }
        if (hasSecurityRealmName) {
            earContext.setHasSecurity(true);
        }
        if ((securityElements = XmlBeansUtil.selectSubstitutionGroupElements((QName)SECURITY_QNAME, (XmlObject)gerWebApp)).length > 0 && !hasSecurityRealmName) {
            throw new DeploymentException("You have supplied a security configuration for web app " + webModule.getName() + " but no security-realm-name to allow login");
        }
        this.getNamingBuilders().buildEnvironment((XmlObject)webApp, (XmlObject)webModule.getVendorDD(), webModule.getEnvironment());
        this.getNamingBuilders().initContext((XmlObject)webApp, gerWebApp, (Module)webModule);
        String originalSpecDD = module.getOriginalSpecDD();
        float originalSpecDDVersion = originalSpecDD == null ? 3.0f : this.identifySpecDDSchemaVersion(originalSpecDD);
        earContext.getGeneralData().put(INITIAL_WEB_XML_SCHEMA_VERSION, Float.valueOf(originalSpecDDVersion));
        if (((Float)INITIAL_WEB_XML_SCHEMA_VERSION.get(earContext.getGeneralData())).floatValue() >= 2.5f && !webApp.getMetadataComplete()) {
            MergeHelper.processWebFragmentsAndAnnotations(earContext, (Module)webModule, bundle, webApp);
        }
        MergeHelper.processServletContainerInitializer(earContext, (Module)webModule, bundle);
        Map<String, String> servletNameToPathMap = this.buildServletNameToPathMap((WebAppType)webModule.getSpecDD(), webModule.getContextRoot());
        Map sharedContext = webModule.getSharedContext();
        for (WebServiceBuilder serviceBuilder : this.webServiceBuilder) {
            serviceBuilder.findWebServices((Module)webModule, false, servletNameToPathMap, webModule.getEnvironment(), sharedContext);
        }
        this.serviceBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)webModule.getEarContext());
    }

    static URI invertURI(URI baseUri) {
        URI resolutionUri = URI.create(".");
        URI test = baseUri;
        while (!test.equals(RELATIVE_MODULE_BASE_URI)) {
            resolutionUri = resolutionUri.resolve(RELATIVE_MODULE_BASE_URI);
            test = test.resolve(RELATIVE_MODULE_BASE_URI);
        }
        return resolutionUri;
    }

    protected String getSpecDDAsString(WebModule module) {
        StringWriter writer = new StringWriter();
        XmlOptions options = new XmlOptions();
        QName webQName = new QName("http://java.sun.com/xml/ns/javaee", "web-app");
        options.setSaveSyntheticDocumentElement(webQName);
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        try {
            ((XmlObject)module.getSpecDD()).save((Writer)writer, options);
        }
        catch (IOException e) {
            // empty catch block
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float identifySpecDDSchemaVersion(String originalSpecDD) {
        float schemaVersion = 0.0f;
        XmlCursor cursor = null;
        try {
            cursor = XmlBeansUtil.parse((String)originalSpecDD).newCursor();
            cursor.toStartDoc();
            cursor.toFirstChild();
            String nameSpaceURI = cursor.getName().getNamespaceURI();
            if (nameSpaceURI != null && nameSpaceURI.length() > 0) {
                String version = cursor.getAttributeText(new QName("", "version"));
                if (version != null) {
                    schemaVersion = Float.parseFloat(version);
                }
            } else {
                XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
                String publicId = xmlDocumentProperties.getDoctypePublicId();
                if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId)) {
                    schemaVersion = 2.2f;
                } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId)) {
                    schemaVersion = 2.3f;
                }
            }
        }
        catch (Exception e) {
            log.error("Fail to identify web.xml schema version", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.dispose();
                }
                catch (Exception e) {}
            }
        }
        return schemaVersion;
    }

    protected ComponentPermissions buildSpecSecurityConfig(EARContext earContext, WebAppType webApp, Bundle bundle) {
        SpecSecurityBuilder builder = new SpecSecurityBuilder(webApp, bundle, ((Float)INITIAL_WEB_XML_SCHEMA_VERSION.get(earContext.getGeneralData())).floatValue() >= 2.5f && !webApp.getMetadataComplete());
        return builder.buildSpecSecurityConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureLocalJaspicProvider(AuthenticationWrapper authType, String contextPath, Module module, GBeanData securityFactoryData) throws DeploymentException, GBeanAlreadyExistsException {
        GBeanData authConfigProviderData;
        EARContext moduleContext;
        block22: {
            moduleContext = module.getEarContext();
            authConfigProviderData = null;
            AbstractName providerName = moduleContext.getNaming().createChildName(module.getModuleName(), "authConfigProvider", "GBean");
            try {
                if (authType.isSetConfigProvider()) {
                    authConfigProviderData = new GBeanData(providerName, AuthConfigProviderGBean.class);
                    XmlCursor xmlCursor = authType.getConfigProvider().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ConfigProviderType configProviderType = JaspiXmlUtil.loadConfigProvider((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeConfigProvider((ConfigProviderType)configProviderType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (authType.isSetServerAuthConfig()) {
                    authConfigProviderData = new GBeanData(providerName, ServerAuthConfigGBean.class);
                    XmlCursor xmlCursor = authType.getServerAuthConfig().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ServerAuthConfigType serverAuthConfigType = JaspiXmlUtil.loadServerAuthConfig((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeServerAuthConfig((ServerAuthConfigType)serverAuthConfigType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (authType.isSetServerAuthContext()) {
                    authConfigProviderData = new GBeanData(providerName, ServerAuthContextGBean.class);
                    XmlCursor xmlCursor = authType.getServerAuthContext().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ServerAuthContextType serverAuthContextType = JaspiXmlUtil.loadServerAuthContext((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeServerAuthContext((ServerAuthContextType)serverAuthContextType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (!authType.isSetServerAuthModule()) break block22;
                authConfigProviderData = new GBeanData(providerName, ServerAuthModuleGBean.class);
                XmlCursor xmlCursor = authType.getServerAuthModule().newCursor();
                try {
                    InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                    AuthModuleType authModuleType = JaspiXmlUtil.loadServerAuthModule((XMLStreamReader)reader);
                    StringWriter out = new StringWriter();
                    JaspiXmlUtil.writeServerAuthModule((AuthModuleType)authModuleType, (Writer)out);
                    authConfigProviderData.setAttribute("config", (Object)out.toString());
                    authConfigProviderData.setAttribute("messageLayer", (Object)MESSAGE_LAYER);
                    authConfigProviderData.setAttribute("appContext", (Object)("server " + contextPath));
                    authConfigProviderData.setAttribute("authenticationID", (Object)contextPath);
                }
                finally {
                    xmlCursor.dispose();
                }
            }
            catch (ParserConfigurationException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (IOException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (SAXException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (JAXBException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
        }
        if (authConfigProviderData != null) {
            moduleContext.addGBean(authConfigProviderData);
            securityFactoryData.addDependency(authConfigProviderData.getAbstractName());
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!FileUtils.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    protected ClassFinder createWebAppClassFinder(WebAppType webApp, WebModule webModule) throws DeploymentException {
        Bundle bundle = webModule.getEarContext().getDeploymentBundle();
        return AbstractWebModuleBuilder.createWebAppClassFinder(webApp, bundle);
    }

    public static ClassFinder createWebAppClassFinder(WebAppType webApp, Bundle bundle) throws DeploymentException {
        FilterType[] filters;
        ListenerType[] listeners;
        ServletType[] servlets;
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ServletType servlet : servlets = webApp.getServletArray()) {
            Class clas;
            FullyQualifiedClassType cls = servlet.getServletClass();
            if (cls == null) continue;
            try {
                clas = bundle.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load servlet class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (ListenerType listener : listeners = webApp.getListenerArray()) {
            Class clas;
            FullyQualifiedClassType cls = listener.getListenerClass();
            try {
                clas = bundle.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load listener class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (FilterType filter : filters = webApp.getFilterArray()) {
            Class clas;
            FullyQualifiedClassType cls = filter.getFilterClass();
            try {
                clas = bundle.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load filter class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        try {
            return new ClassFinder(classes);
        }
        catch (NoClassDefFoundError e) {
            throw new DeploymentException("Classloader for " + webApp.getId() + "can't find " + e.getMessage(), (Throwable)e);
        }
    }

    private static void addClass(List<Class> classes, Class<?> clas) {
        while (clas != Object.class) {
            classes.add(clas);
            clas = clas.getSuperclass();
        }
    }

    protected void configureBasicWebModuleAttributes(WebAppType webApp, XmlObject vendorPlan, EARContext moduleContext, EARContext earContext, WebModule webModule, GBeanData webModuleData) throws DeploymentException {
        HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleContext.getModuleName());
        HashMap<JndiKey, Map<String, Object>> jndiContext = new HashMap<JndiKey, Map<String, Object>>((Map)NamingBuilder.JNDI_KEY.get(earContext.getGeneralData()));
        AbstractWebModuleBuilder.getJndiContext(jndiContext, JndiScope.module).put("module/ModuleName", webModule.getName());
        buildingContext.put(NamingBuilder.JNDI_KEY, jndiContext);
        if (!webApp.getMetadataComplete()) {
            webModule.setClassFinder(this.createWebAppClassFinder(webApp, webModule));
            SecurityAnnotationHelper.processAnnotations((WebAppType)webApp, (ClassFinder)webModule.getClassFinder());
        }
        this.getNamingBuilders().buildNaming((XmlObject)webApp, vendorPlan, (Module)webModule, buildingContext);
        AbstractName contextSourceName = moduleContext.getNaming().createChildName(webModuleData.getAbstractName(), "ContextSource", "ContextSource");
        GBeanData contextSourceData = new GBeanData(contextSourceName, WebContextSource.class);
        contextSourceData.setAttribute("componentContext", jndiContext.get(JndiScope.comp));
        contextSourceData.setAttribute("moduleContext", jndiContext.get(JndiScope.module));
        contextSourceData.setReferencePattern("ApplicationJndi", (AbstractName)EARContext.APPLICATION_JNDI_NAME_KEY.get(earContext.getGeneralData()));
        contextSourceData.setReferencePattern("TransactionManager", moduleContext.getTransactionManagerName());
        try {
            moduleContext.addGBean(contextSourceData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("ContextSource for this webapp already present:" + webModuleData.getAbstractName(), (Throwable)e);
        }
        webModuleData.setReferencePattern("ContextSource", contextSourceName);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(buildingContext);
        webModule.getSharedContext().put("WEB_APP_DATA", webModuleData);
        webModule.getSharedContext().put(NamingBuilder.JNDI_KEY, jndiContext);
        webModule.getSharedContext().put(NamingBuilder.INJECTION_KEY, holder);
        if (moduleContext.getServerName() != null) {
            webModuleData.setReferencePattern("J2EEServer", moduleContext.getServerName());
        }
        if (!webModule.isStandAlone()) {
            webModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
        }
        webModuleData.setAttribute("holder", (Object)holder);
        if (earContext != moduleContext) {
            this.addGBeanDependencies(earContext, webModuleData);
        }
        webModuleData.setReferencePattern("TransactionManager", moduleContext.getTransactionManagerName());
        webModuleData.setReferencePattern("TrackedConnectionAssociator", moduleContext.getConnectionTrackerName());
        webModuleData.setAttribute("modulePath", webModule.isStandAlone() || webModule.getEarContext() != webModule.getRootEarContext() ? null : webModule.getTargetPath());
    }

    private static Map<String, Object> getJndiContext(Map<JndiKey, Map<String, Object>> contexts, JndiScope scope) {
        Map<String, Object> context = contexts.get(scope);
        if (context == null) {
            context = new HashMap<String, Object>();
            contexts.put((JndiKey)scope, context);
        }
        return context;
    }

    static {
        SECURITY_QNAME = GerSecurityDocument.type.getDocumentElementName();
        RELATIVE_MODULE_BASE_URI = URI.create("../");
        MANAGED_CONNECTION_FACTORY_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        ADMIN_OBJECT_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAAdminObject"));
        STATELESS_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatelessSessionBean"));
        STATEFUL_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatefulSessionBean"));
        ENTITY_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "EntityBean"));
    }

    private static class InternWrapper
    implements XMLStreamReader {
        private final XMLStreamReader delegate;

        private InternWrapper(XMLStreamReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws XMLStreamException {
            this.delegate.close();
        }

        @Override
        public int getAttributeCount() {
            return this.delegate.getAttributeCount();
        }

        @Override
        public String getAttributeLocalName(int i) {
            return this.delegate.getAttributeLocalName(i);
        }

        @Override
        public QName getAttributeName(int i) {
            return this.delegate.getAttributeName(i);
        }

        @Override
        public String getAttributeNamespace(int i) {
            return this.delegate.getAttributeNamespace(i);
        }

        @Override
        public String getAttributePrefix(int i) {
            return this.delegate.getAttributePrefix(i);
        }

        @Override
        public String getAttributeType(int i) {
            return this.delegate.getAttributeType(i);
        }

        @Override
        public String getAttributeValue(int i) {
            return this.delegate.getAttributeValue(i);
        }

        @Override
        public String getAttributeValue(String s, String s1) {
            return this.delegate.getAttributeValue(s, s1);
        }

        @Override
        public String getCharacterEncodingScheme() {
            return this.delegate.getCharacterEncodingScheme();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            return this.delegate.getElementText();
        }

        @Override
        public String getEncoding() {
            return this.delegate.getEncoding();
        }

        @Override
        public int getEventType() {
            return this.delegate.getEventType();
        }

        @Override
        public String getLocalName() {
            return this.delegate.getLocalName().intern();
        }

        @Override
        public Location getLocation() {
            return this.delegate.getLocation();
        }

        @Override
        public QName getName() {
            return this.delegate.getName();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        @Override
        public int getNamespaceCount() {
            return this.delegate.getNamespaceCount();
        }

        @Override
        public String getNamespacePrefix(int i) {
            return this.delegate.getNamespacePrefix(i);
        }

        @Override
        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI().intern();
        }

        @Override
        public String getNamespaceURI(int i) {
            return this.delegate.getNamespaceURI(i);
        }

        @Override
        public String getNamespaceURI(String s) {
            return this.delegate.getNamespaceURI(s);
        }

        @Override
        public String getPIData() {
            return this.delegate.getPIData();
        }

        @Override
        public String getPITarget() {
            return this.delegate.getPITarget();
        }

        @Override
        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        @Override
        public Object getProperty(String s) throws IllegalArgumentException {
            return this.delegate.getProperty(s);
        }

        @Override
        public String getText() {
            return this.delegate.getText();
        }

        @Override
        public char[] getTextCharacters() {
            return this.delegate.getTextCharacters();
        }

        @Override
        public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
            return this.delegate.getTextCharacters(i, chars, i1, i2);
        }

        @Override
        public int getTextLength() {
            return this.delegate.getTextLength();
        }

        @Override
        public int getTextStart() {
            return this.delegate.getTextStart();
        }

        @Override
        public String getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public boolean hasName() {
            return this.delegate.hasName();
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasText() {
            return this.delegate.hasText();
        }

        @Override
        public boolean isAttributeSpecified(int i) {
            return this.delegate.isAttributeSpecified(i);
        }

        @Override
        public boolean isCharacters() {
            return this.delegate.isCharacters();
        }

        @Override
        public boolean isEndElement() {
            return this.delegate.isEndElement();
        }

        @Override
        public boolean isStandalone() {
            return this.delegate.isStandalone();
        }

        @Override
        public boolean isStartElement() {
            return this.delegate.isStartElement();
        }

        @Override
        public boolean isWhiteSpace() {
            return this.delegate.isWhiteSpace();
        }

        @Override
        public int next() throws XMLStreamException {
            return this.delegate.next();
        }

        @Override
        public int nextTag() throws XMLStreamException {
            return this.delegate.nextTag();
        }

        @Override
        public void require(int i, String s, String s1) throws XMLStreamException {
            this.delegate.require(i, s, s1);
        }

        @Override
        public boolean standaloneSet() {
            return this.delegate.standaloneSet();
        }
    }
}

