/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.util.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.DEROutputStream;
import org.apache.geronimo.util.asn1.x509.TBSCertList;
import org.apache.geronimo.util.asn1.x509.X509Extension;
import org.apache.geronimo.util.asn1.x509.X509Extensions;

public class X509CRLEntryObject
extends X509CRLEntry {
    private TBSCertList.CRLEntry c;

    public X509CRLEntryObject(TBSCertList.CRLEntry c) {
        this.c = c;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        X509Extensions extensions = this.c.getExtensions();
        if (extensions != null) {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.c.getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    public BigInteger getSerialNumber() {
        return this.c.getUserCertificate().getValue();
    }

    public Date getRevocationDate() {
        return this.c.getRevocationDate().getDate();
    }

    public boolean hasExtensions() {
        return this.c.getExtensions() != null;
    }

    public String toString() {
        Enumeration e;
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("      userCertificate: " + this.getSerialNumber() + nl);
        buf.append("       revocationDate: " + this.getRevocationDate() + nl);
        X509Extensions extensions = this.c.getExtensions();
        if (extensions != null && (e = extensions.oids()).hasMoreElements()) {
            buf.append("   crlEntryExtensions:" + nl);
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                buf.append(ext);
            }
        }
        return buf.toString();
    }
}

