/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transformer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerCollection
implements ClassFileTransformer {
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean changed = false;
        for (ClassFileTransformer transformer : this.transformers) {
            byte[] transformed = transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            if (transformed == null) continue;
            changed = true;
            classfileBuffer = transformed;
        }
        return (byte[])(changed ? classfileBuffer : null);
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.transformers.add(classFileTransformer);
    }

    public void removeTransformer(ClassFileTransformer classFileTransformer) {
        this.transformers.remove(classFileTransformer);
    }
}

