/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.wrapper.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import javax.management.j2ee.statistics.Stats;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.stats.JTAStatsImpl;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@GBean(j2eeType="JTAResource")
public class GeronimoTransactionManagerGBean
extends GeronimoTransactionManager
implements StatisticsProvider,
GBeanLifecycle {
    private final BundleContext bundleContext;
    private final JTAStatsImpl stats = new JTAStatsImpl();
    private ServiceRegistration serviceRegistration;

    public GeronimoTransactionManagerGBean(@ParamAttribute(name="defaultTransactionTimeoutSeconds") int defaultTransactionTimeoutSeconds, @ParamReference(name="XidFactory", namingType="XIDFactory") XidFactory xidFactory, @ParamReference(name="TransactionLog", namingType="TransactionLog") TransactionLog transactionLog, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws XAException {
        super(defaultTransactionTimeoutSeconds == 0 ? 600 : defaultTransactionTimeoutSeconds, xidFactory, transactionLog);
        this.bundleContext = bundleContext;
        this.stats.setStartTime();
    }

    public void resetStats() {
        this.stats.setStartTime();
        super.resetStatistics();
    }

    public Stats getStats() {
        try {
            this.stats.getActiveCountImpl().setCount(super.getActiveCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stats.getCommittedCountImpl().setCount(super.getTotalCommits());
        this.stats.getRolledbackCountImpl().setCount(super.getTotalRollbacks());
        this.stats.setLastSampleTime();
        return this.stats;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return false;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        ArrayList<String> clazzes = new ArrayList<String>();
        clazzes.add(TransactionManager.class.getName());
        clazzes.add(TransactionSynchronizationRegistry.class.getName());
        clazzes.add(UserTransaction.class.getName());
        clazzes.add(RecoverableTransactionManager.class.getName());
        this.serviceRegistration = this.bundleContext.registerService(clazzes.toArray(new String[clazzes.size()]), (Object)this, (Dictionary)new Properties());
    }

    public void doStop() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

