/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;

public class PolicyContextBeforeAfter
implements BeforeAfter {
    public static final String DEFAULT_SUBJECT = "~DEFAULT_SUBJECT";
    private final BeforeAfter next;
    private final String policyContextID;
    private final int policyContextIDIndex;
    private final int callersIndex;
    private final int defaultSubjectIndex;
    private final Subject defaultSubject;

    public PolicyContextBeforeAfter(BeforeAfter next, int policyContextIDIndex, int callersIndex, int defaultSubjectIndex, String policyContextID, Subject defaultSubject) {
        this.next = next;
        this.policyContextIDIndex = policyContextIDIndex;
        this.callersIndex = callersIndex;
        this.defaultSubjectIndex = defaultSubjectIndex;
        this.policyContextID = policyContextID;
        this.defaultSubject = defaultSubject;
    }

    @Override
    public void before(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        try {
            beforeAfterContext.contexts[this.callersIndex] = ContextManager.getCallers();
            beforeAfterContext.clearRequiredFlags[this.callersIndex] = true;
            if (httpRequest != null) {
                beforeAfterContext.contexts[this.defaultSubjectIndex] = httpRequest.getAttribute(DEFAULT_SUBJECT);
                httpRequest.setAttribute(DEFAULT_SUBJECT, (Object)this.defaultSubject);
                beforeAfterContext.clearRequiredFlags[this.defaultSubjectIndex] = true;
            }
            if (this.next != null) {
                this.next.before(beforeAfterContext, httpRequest, httpResponse, dispatch);
            }
        }
        catch (RuntimeException e) {
            if (beforeAfterContext.clearRequiredFlags[this.callersIndex]) {
                ContextManager.popCallers((Callers)((Callers)beforeAfterContext.contexts[this.callersIndex]));
                beforeAfterContext.clearRequiredFlags[this.callersIndex] = false;
            }
            if (beforeAfterContext.clearRequiredFlags[this.defaultSubjectIndex]) {
                httpRequest.setAttribute(DEFAULT_SUBJECT, beforeAfterContext.contexts[this.defaultSubjectIndex]);
                beforeAfterContext.clearRequiredFlags[this.defaultSubjectIndex] = false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        try {
            if (this.next != null) {
                this.next.after(beforeAfterContext, httpRequest, httpResponse, dispatch);
            }
        }
        finally {
            if (beforeAfterContext.clearRequiredFlags[this.callersIndex]) {
                ContextManager.popCallers((Callers)((Callers)beforeAfterContext.contexts[this.callersIndex]));
                beforeAfterContext.clearRequiredFlags[this.callersIndex] = false;
            }
            if (beforeAfterContext.clearRequiredFlags[this.defaultSubjectIndex]) {
                httpRequest.setAttribute(DEFAULT_SUBJECT, beforeAfterContext.contexts[this.defaultSubjectIndex]);
                beforeAfterContext.clearRequiredFlags[this.defaultSubjectIndex] = false;
            }
        }
    }
}

