/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.tomcat.util.IntrospectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(ManagerGBean.class);
    public static final String J2EE_TYPE = "Manager";
    protected final Manager manager;
    public static final GBeanInfo GBEAN_INFO;
    public static final Map<String, ParametersHandler> CLASSNAME_PARAMETERHANDLER_MAP;
    public static final String DEFAULT_PARAMETER_HANDLER = "default";

    public ManagerGBean() {
        this.manager = null;
    }

    protected ManagerGBean(String className) throws Exception {
        this.manager = (Manager)Class.forName(className).newInstance();
    }

    public ManagerGBean(String className, Map initParams) throws Exception {
        if (className == null) {
            className = "org.apache.catalina.session.StandardManager";
        }
        this.manager = (Manager)Class.forName(className).newInstance();
        if (CLASSNAME_PARAMETERHANDLER_MAP.containsKey(className)) {
            CLASSNAME_PARAMETERHANDLER_MAP.get(className).handle(this.manager, initParams);
        } else {
            CLASSNAME_PARAMETERHANDLER_MAP.get(DEFAULT_PARAMETER_HANDLER).handle(this.manager, initParams);
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    @Override
    public Object getInternalObject() {
        return this.manager;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        CLASSNAME_PARAMETERHANDLER_MAP = new HashMap<String, ParametersHandler>();
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"TomcatManager", ManagerGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addOperation("getInternalObject");
        infoFactory.setConstructor(new String[]{"className", "initParams"});
        GBEAN_INFO = infoFactory.getBeanInfo();
        CLASSNAME_PARAMETERHANDLER_MAP.put(DEFAULT_PARAMETER_HANDLER, new DefaultParametersHandler());
        CLASSNAME_PARAMETERHANDLER_MAP.put("org.apache.catalina.session.PersistentManager", new PersistentManagerBaseParametersHandler());
        CLASSNAME_PARAMETERHANDLER_MAP.put("org.apache.catalina.session.DistributedManager", new PersistentManagerBaseParametersHandler());
    }

    static class PersistentManagerBaseParametersHandler
    implements ParametersHandler {
        private static final String STORE_CLASSNAME = "store.className";
        private static final String STORE_PARAMETER_PREFIX = "store.";

        PersistentManagerBaseParametersHandler() {
        }

        @Override
        public void handle(Object managerObject, Map<String, String> nameValueMap) throws Exception {
            if (!nameValueMap.containsKey(STORE_CLASSNAME) || nameValueMap.get(STORE_CLASSNAME) == null) {
                throw new IllegalArgumentException("store.className should be set to indicate which implementation is used");
            }
            Store store = (Store)Class.forName(nameValueMap.get(STORE_CLASSNAME).trim()).newInstance();
            nameValueMap.remove(STORE_CLASSNAME);
            for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
                String sCurrentParameterName = entry.getKey();
                String sCurrentParameterValue = entry.getValue();
                if (sCurrentParameterValue != null) {
                    sCurrentParameterValue = sCurrentParameterValue.trim();
                }
                if (sCurrentParameterName.indexOf(STORE_PARAMETER_PREFIX) == 0) {
                    int iDotIndex = sCurrentParameterName.indexOf(46);
                    String sStoreParameterName = sCurrentParameterName.substring(iDotIndex + 1);
                    if (IntrospectionUtils.setProperty((Object)store, (String)sStoreParameterName, (String)sCurrentParameterValue)) {
                        log.debug("Property [" + sStoreParameterName + "] of the store object is set with [" + sCurrentParameterValue + "]");
                        continue;
                    }
                    log.warn("Fail to set the property [" + sStoreParameterName + "] of the store object with [" + sCurrentParameterValue + "]");
                    continue;
                }
                if (IntrospectionUtils.setProperty((Object)managerObject, (String)sCurrentParameterName, (String)sCurrentParameterValue)) {
                    log.debug("Property [" + sCurrentParameterName + "] of the manager object is set with [" + sCurrentParameterValue + "]");
                    continue;
                }
                log.warn("Fail to set the property [" + sCurrentParameterName + "] of the manager object with [" + sCurrentParameterValue + "]");
            }
            ((PersistentManagerBase)managerObject).setStore(store);
        }
    }

    static class DefaultParametersHandler
    implements ParametersHandler {
        DefaultParametersHandler() {
        }

        @Override
        public void handle(Object managerObject, Map<String, String> nameValueMap) throws Exception {
            for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
                String currentParameterName = entry.getKey();
                String currentParameterValue = entry.getValue();
                if (currentParameterValue != null) {
                    currentParameterValue = currentParameterValue.trim();
                }
                IntrospectionUtils.setProperty((Object)managerObject, (String)currentParameterName, (String)currentParameterValue);
            }
        }
    }

    public static interface ParametersHandler {
        public void handle(Object var1, Map<String, String> var2) throws Exception;
    }
}

