/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication.jaspic;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicCallbackHandler;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicMessageInfo;

public class JaspicAuthenticator
implements Authenticator {
    private static final String MESSAGE_INFO_KEY = "org.apache.geronimo.tomcat.jaspic.message.info";
    public static final String CONTAINER_CACHING_KEY = "org.apache.geronimo.jaspic.servlet.containerCaching";
    private final ServerAuthConfig serverAuthConfig;
    private final Map authProperties;
    private final Subject serviceSubject;
    private final JaspicCallbackHandler callbackHandler;
    private final IdentityService identityService;
    private final boolean containerCaching;

    public JaspicAuthenticator(ServerAuthConfig serverAuthConfig, Map authProperties, Subject serviceSubject, JaspicCallbackHandler callbackHandler, IdentityService identityService) {
        this.serverAuthConfig = serverAuthConfig;
        this.authProperties = authProperties;
        this.serviceSubject = serviceSubject;
        this.callbackHandler = callbackHandler;
        this.identityService = identityService;
        this.containerCaching = authProperties != null && authProperties.get(CONTAINER_CACHING_KEY) != null && Boolean.valueOf((String)authProperties.get(CONTAINER_CACHING_KEY)) != false;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        try {
            JaspicMessageInfo messageInfo = new JaspicMessageInfo(request, response, isAuthMandatory);
            if (cachedIdentity != null) {
                messageInfo.getMap().put("org.apache.geronimo.jaspic.servlet.cachedIdentity", cachedIdentity);
            }
            request.setNote(MESSAGE_INFO_KEY, (Object)messageInfo);
            String authContextId = this.serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this.serverAuthConfig.getAuthContext(authContextId, this.serviceSubject, this.authProperties);
            Subject clientSubject = new Subject();
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject, this.serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null, false);
            }
            if (authStatus == AuthStatus.SUCCESS) {
                UserIdentity userIdentity;
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (ids.size() > 0) {
                    userIdentity = ids.iterator().next();
                } else {
                    GroupPrincipalCallback groupPrincipalCallback;
                    CallerPrincipalCallback principalCallback = this.callbackHandler.getThreadCallerPrincipalCallback();
                    if (principalCallback == null) {
                        throw new NullPointerException("No CallerPrincipalCallback");
                    }
                    Principal principal = principalCallback.getPrincipal();
                    if (principal == null) {
                        String principalName = principalCallback.getName();
                        Set<Principal> principals = principalCallback.getSubject().getPrincipals();
                        for (Principal p : principals) {
                            if (!p.getName().equals(principalName)) continue;
                            principal = p;
                            break;
                        }
                        if (principal == null) {
                            return new AuthResult(TomcatAuthStatus.SUCCESS, null, false);
                        }
                    }
                    String[] groups = (groupPrincipalCallback = this.callbackHandler.getThreadGroupPrincipalCallback()) == null ? null : groupPrincipalCallback.getGroups();
                    userIdentity = this.identityService.newUserIdentity(clientSubject, principal, groups == null ? Collections.emptyList() : Arrays.asList(groups));
                }
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, this.containerCaching);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return new AuthResult(TomcatAuthStatus.SEND_SUCCESS, null, false);
            }
            throw new NullPointerException("No AuthStatus returned");
        }
        catch (AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        JaspicMessageInfo messageInfo = (JaspicMessageInfo)request.getNote(MESSAGE_INFO_KEY);
        if (messageInfo == null) {
            throw new NullPointerException("MessageInfo from request missing: " + request);
        }
        try {
            String authContextId = this.serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this.serverAuthConfig.getAuthContext(authContextId, this.serviceSubject, this.authProperties);
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this.serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    @Override
    public String getAuthType() {
        return "JASPIC";
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(new Subject(), username, password.toCharArray());
        try {
            this.callbackHandler.handle(new Callback[]{passwordValidationCallback});
            if (passwordValidationCallback.getResult()) {
                UserIdentity userIdentity = passwordValidationCallback.getSubject().getPrivateCredentials(UserIdentity.class).iterator().next();
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, this.containerCaching);
            }
            return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
        }
        catch (UnsupportedCallbackException e) {
            throw new ServletException("internal server error");
        }
        catch (IOException e) {
            throw new ServletException("Unsuccessful login");
        }
    }

    @Override
    public void logout(Request request) throws ServletException {
        JaspicMessageInfo messageInfo = (JaspicMessageInfo)request.getNote(MESSAGE_INFO_KEY);
        if (messageInfo == null) {
            throw new NullPointerException("MessageInfo from request missing: " + request);
        }
        Subject subject = ContextManager.getCurrentCaller();
        if (subject != null) {
            this.identityService.associate(null);
            try {
                String authContextId = this.serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
                ServerAuthContext authContext = this.serverAuthConfig.getAuthContext(authContextId, this.serviceSubject, this.authProperties);
                authContext.cleanSubject((MessageInfo)messageInfo, subject);
            }
            catch (AuthException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

