/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class SecurityValve
extends ValveBase
implements org.apache.catalina.Authenticator {
    public static final String CACHED_IDENTITY_KEY = "org.apache.geronimo.jaspic.servlet.cachedIdentity";
    private final Authenticator authenticator;
    private final Authorizer authorizer;
    private final IdentityService identityService;

    public SecurityValve(Authenticator authenticator, Authorizer authorizer, IdentityService identityService) {
        super(true);
        this.authenticator = authenticator;
        this.authorizer = authorizer;
        this.identityService = identityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block11: {
            Object constraints = this.authorizer.getConstraints(request);
            if (!this.authorizer.hasUserDataPermissions(request, constraints)) {
                if (!response.isError()) {
                    response.sendError(403);
                }
                return;
            }
            boolean isAuthMandatory = this.authorizer.isAuthMandatory(request, constraints);
            try {
                AuthResult authResult = this.authenticator.validateRequest(request, (HttpServletResponse)response, isAuthMandatory, this.getCachedIdentity(request));
                TomcatAuthStatus authStatus = authResult.getAuthStatus();
                if (authStatus == TomcatAuthStatus.FAILURE) break block11;
                if (authStatus == TomcatAuthStatus.SEND_CONTINUE) {
                    this.cacheIdentity(request, authResult);
                    break block11;
                }
                if (authStatus == TomcatAuthStatus.SEND_FAILURE || authStatus == TomcatAuthStatus.SEND_SUCCESS) break block11;
                if (authStatus == TomcatAuthStatus.SUCCESS) {
                    Object previous = this.doSuccess(request, authResult);
                    if (isAuthMandatory && !this.authorizer.hasResourcePermissions(request, authResult, constraints, authResult.getUserIdentity())) {
                        if (!response.isError()) {
                            response.sendError(403);
                        }
                        return;
                    }
                    try {
                        this.getNext().invoke(request, response);
                    }
                    finally {
                        this.identityService.dissociate(previous);
                    }
                    this.authenticator.secureResponse(request, response, authResult);
                    break block11;
                }
                throw new ServletException("unexpected auth status: " + (Object)((Object)authStatus));
            }
            catch (ServerAuthException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Object doSuccess(Request request, AuthResult authResult) {
        Principal principal;
        this.cacheIdentity(request, authResult);
        UserIdentity userIdentity = authResult.getUserIdentity();
        Principal principal2 = principal = userIdentity == null ? null : userIdentity.getUserPrincipal();
        if (principal != null) {
            request.setAuthType(this.authenticator.getAuthType());
            request.setUserPrincipal(principal);
        }
        return this.identityService.associate(userIdentity);
    }

    private void cacheIdentity(Request request, AuthResult authResult) {
        UserIdentity userIdentity = authResult.getUserIdentity();
        if (userIdentity != null && authResult.isContainerCaching()) {
            Session session = request.getSessionInternal(true);
            session.setNote(CACHED_IDENTITY_KEY, (Object)userIdentity);
        }
    }

    private UserIdentity getCachedIdentity(Request request) {
        Session session = request.getSessionInternal(false);
        return session == null ? null : (UserIdentity)session.getNote(CACHED_IDENTITY_KEY);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        try {
            AuthResult authResult = this.authenticator.validateRequest(request, response, true, this.getCachedIdentity(request));
            TomcatAuthStatus authStatus = authResult.getAuthStatus();
            if (TomcatAuthStatus.SUCCESS.equals((Object)authStatus)) {
                this.doSuccess(request, authResult);
                return true;
            }
            return false;
        }
        catch (ServerAuthException e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    public void login(String username, String password, Request request) throws ServletException {
        AuthResult authResult = this.authenticator.login(username, password, request);
        TomcatAuthStatus authStatus = authResult.getAuthStatus();
        if (authStatus != TomcatAuthStatus.SUCCESS) {
            throw new ServletException("Could not log in");
        }
        this.doSuccess(request, authResult);
    }

    public void logout(Request request) throws ServletException {
        this.authenticator.logout(request);
        request.setUserPrincipal(null);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.removeNote(CACHED_IDENTITY_KEY);
        }
        this.identityService.associate(null);
    }
}

