/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.tribes.Channel;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.ChannelGBean;
import org.apache.geronimo.tomcat.cluster.ClusterDeployerGBean;
import org.apache.geronimo.tomcat.cluster.ClusterListenerGBean;
import org.apache.geronimo.tomcat.cluster.ClusterManagerGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalinaClusterGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(CatalinaClusterGBean.class);
    public static final String J2EE_TYPE = "Cluster";
    private final CatalinaCluster cluster;
    public static final GBeanInfo GBEAN_INFO;

    public CatalinaClusterGBean() {
        this.cluster = null;
    }

    public CatalinaClusterGBean(String className, Map initParams, ClusterListenerGBean clusterListenerChain, ValveGBean tomcatValveChain, ClusterDeployerGBean deployer, ChannelGBean channel, ClusterManagerGBean manager) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("Must have a 'className' attribute.");
        }
        this.cluster = (CatalinaCluster)Class.forName(className).newInstance();
        this.setParameters(this.cluster, initParams);
        if (clusterListenerChain != null) {
            for (ClusterListenerGBean clusterListenerGBean = clusterListenerChain; clusterListenerGBean != null; clusterListenerGBean = clusterListenerGBean.getNextValve()) {
                this.cluster.addClusterListener((ClusterListener)clusterListenerGBean.getInternalObject());
            }
        }
        if (tomcatValveChain != null) {
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                this.cluster.addValve((Valve)valveGBean.getInternalObject());
            }
        }
        if (deployer != null) {
            this.cluster.setClusterDeployer((ClusterDeployer)deployer.getInternalObject());
        }
        if (channel != null) {
            this.cluster.setChannel((Channel)channel.getInternalObject());
        }
        if (manager != null) {
            this.cluster.registerManager((Manager)((ClusterManager)manager.getInternalObject()));
        }
    }

    @Override
    public Object getInternalObject() {
        return this.cluster;
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Started cluster gbean.");
    }

    public void doStop() throws Exception {
        log.debug("Stopped cluster gbean.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"CatalinaCluster", CatalinaClusterGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("ClusterListenerChain", ClusterListenerGBean.class, "ClusterListener");
        infoFactory.addReference("TomcatValveChain", ValveGBean.class, "TomcatValve");
        infoFactory.addReference("ClusterDeployer", ClusterDeployerGBean.class, "ClusterDeployer");
        infoFactory.addReference("Channel", ChannelGBean.class, "Channel");
        infoFactory.addReference("ClusterManager", ClusterManagerGBean.class, "ClusterManager");
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.setConstructor(new String[]{"className", "initParams", "ClusterListenerChain", "TomcatValveChain", "ClusterDeployer", "Channel", "ClusterManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

