/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.core.GeronimoApplicationContext;
import org.apache.geronimo.web.security.SpecSecurityBuilder;

public class GeronimoApplicationServletRegistrationAdapter
implements ServletRegistration.Dynamic {
    private ServletRegistration.Dynamic applicationServletRegistration;
    private Wrapper wrapper;
    private GeronimoStandardContext standardContext;
    private GeronimoApplicationContext applicationContext;

    public GeronimoApplicationServletRegistrationAdapter(GeronimoStandardContext standardContext, GeronimoApplicationContext applicationContext, Wrapper wrapper, ServletRegistration.Dynamic applicationServletRegistration) {
        this.applicationServletRegistration = applicationServletRegistration;
        this.standardContext = standardContext;
        this.wrapper = wrapper;
        this.applicationContext = applicationContext;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.applicationServletRegistration.setLoadOnStartup(loadOnStartup);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.applicationServletRegistration.setMultipartConfig(multipartConfig);
    }

    public void setRunAsRole(String roleName) {
        this.applicationServletRegistration.setRunAsRole(roleName);
        SpecSecurityBuilder specSecurityBuilder = this.applicationContext.getSpecSecurityBuilder();
        specSecurityBuilder.declareRoles(new String[]{roleName});
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException("ServletSecurityElement configured by setServletSecurity should not be null");
        }
        if (this.standardContext.getState() != LifecycleState.STARTING_PREP) {
            throw new IllegalStateException("setServletSecurity action is not allowed after the context " + this.standardContext.getPath() + " is initialized");
        }
        SpecSecurityBuilder specSecurityBuilder = this.applicationContext.getSpecSecurityBuilder();
        if (specSecurityBuilder == null) {
            throw new IllegalStateException("Web security builder is null, setServletSecurity action is not supported, you must make sure enable the security configuration while deploying the web application");
        }
        return specSecurityBuilder.setServletSecurity(constraint, this.getMappings());
    }

    public Set<String> addMapping(String ... urlPatterns) {
        return this.applicationServletRegistration.addMapping(urlPatterns);
    }

    public Collection<String> getMappings() {
        return this.applicationServletRegistration.getMappings();
    }

    public String getRunAsRole() {
        return this.applicationServletRegistration.getRunAsRole();
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.applicationServletRegistration.setAsyncSupported(asyncSupported);
    }

    public String getClassName() {
        return this.applicationServletRegistration.getClassName();
    }

    public String getInitParameter(String name) {
        return this.applicationServletRegistration.getInitParameter(name);
    }

    public Map<String, String> getInitParameters() {
        return this.applicationServletRegistration.getInitParameters();
    }

    public String getName() {
        return this.applicationServletRegistration.getName();
    }

    public boolean setInitParameter(String name, String value) {
        return this.applicationServletRegistration.setInitParameter(name, value);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.applicationServletRegistration.setInitParameters(initParameters);
    }
}

