/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.Map;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRProtocol;

@GBean(name="Tomcat Connector HTTP APR")
public class Http11APRConnectorGBean
extends BaseHttp11ConnectorGBean
implements Http11APRProtocol {
    private String certificateFile;
    private String certificateKeyFile;
    private String caCertificateFile;
    private String caCertificatePath;
    private String certificateChainFile;
    private String revocationPath;
    private String revocationFile;

    public Http11APRConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="host") String host, @ParamAttribute(manageable=false, name="port") int port, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        super(name, initParams, "org.apache.coyote.http11.Http11AprProtocol", host, port, container, serverInfo, conn);
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public String getGeronimoProtocol() {
        return "HTTP";
    }

    @Override
    public int getPollTime() {
        Object value = this.connector.getAttribute("pollTime");
        return value == null ? 2000 : new Integer(value.toString());
    }

    @Override
    public int getPollerSize() {
        Object value = this.connector.getAttribute("pollerSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    @Override
    public int getSendfileSize() {
        Object value = this.connector.getAttribute("sendfileSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    @Override
    public String getSslCACertificateFile() {
        String path = (String)this.connector.getAttribute("SSLCACertificateFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCACertificatePath() {
        String path = (String)this.connector.getAttribute("SSLCACertificatePath");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCertificateChainFile() {
        String path = (String)this.connector.getAttribute("truststoreFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCertificateFile() {
        String path = (String)this.connector.getAttribute("SSLCertificateFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCertificateKeyFile() {
        String path = (String)this.connector.getAttribute("SSLCertificateKeyFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCipherSuite() {
        return (String)this.connector.getAttribute("SSLCipherSuite");
    }

    @Override
    public String getSslProtocol() {
        return (String)this.connector.getAttribute("SSLProtocol");
    }

    @Override
    public String getSslCARevocationFile() {
        String path = (String)this.connector.getAttribute("SSLCARevocationFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslCARevocationPath() {
        String path = (String)this.connector.getAttribute("SSLCARevocationPath");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    @Override
    public String getSslVerifyClient() {
        return (String)this.connector.getAttribute("SSLVerifyClient");
    }

    @Override
    public int getSslVerifyDepth() {
        Object value = this.connector.getAttribute("SSLVerifyDepth");
        return value == null ? 10 : new Integer(value.toString());
    }

    @Override
    public boolean getUseSendfile() {
        Object value = this.connector.getAttribute("useSendfile");
        return value == null ? true : new Boolean(value.toString());
    }

    @Override
    public String getSslPassword() {
        return (String)this.connector.getAttribute("SSLPassword");
    }

    @Override
    @Persistent(manageable=false)
    public void setPollTime(int pollTime) {
        this.connector.setAttribute("pollTime", (Object)pollTime);
    }

    @Override
    @Persistent(manageable=false)
    public void setPollerSize(int pollerSize) {
        this.connector.setAttribute("pollerSize", (Object)pollerSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setSendfileSize(int sendfileSize) {
        this.connector.setAttribute("sendfileSize", (Object)sendfileSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCACertificateFile(String sslCACertificateFile) {
        if (sslCACertificateFile != null && sslCACertificateFile.equals("")) {
            sslCACertificateFile = null;
        }
        this.caCertificateFile = sslCACertificateFile;
        if (this.caCertificateFile == null) {
            this.connector.setAttribute("SSLCACertificateFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.caCertificateFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCACertificateFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCACertificatePath(String sslCACertificatePath) {
        if (sslCACertificatePath != null && sslCACertificatePath.equals("")) {
            sslCACertificatePath = null;
        }
        this.caCertificatePath = sslCACertificatePath;
        if (this.caCertificatePath == null) {
            this.connector.setAttribute("SSLCACertificatePath", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.caCertificatePath);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCACertificatePath", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCertificateChainFile(String sslCertificateChainFile) {
        if (sslCertificateChainFile != null && sslCertificateChainFile.equals("")) {
            sslCertificateChainFile = null;
        }
        this.certificateChainFile = sslCertificateChainFile;
        if (this.certificateChainFile == null) {
            this.connector.setAttribute("SSLCertificateChainFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.certificateChainFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCertificateChainFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCertificateFile(String sslCertificateFile) {
        if (sslCertificateFile != null && sslCertificateFile.equals("")) {
            sslCertificateFile = null;
        }
        this.certificateFile = sslCertificateFile;
        if (this.certificateFile == null) {
            this.connector.setAttribute("SSLCertificateFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.certificateFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCertificateFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCertificateKeyFile(String sslCertificateKeyFile) {
        if (sslCertificateKeyFile != null && sslCertificateKeyFile.equals("")) {
            sslCertificateKeyFile = null;
        }
        this.certificateKeyFile = sslCertificateKeyFile;
        if (this.certificateKeyFile == null) {
            this.connector.setAttribute("SSLCertificateKeyFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.certificateKeyFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCertificateKeyFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCipherSuite(String sslCipherSuite) {
        this.connector.setAttribute("SSLCipherSuite", (Object)sslCipherSuite);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslPassword(String sslPassword) {
        if (sslPassword != null && sslPassword.equals("")) {
            sslPassword = null;
        }
        this.connector.setAttribute("SSLPassword", (Object)sslPassword);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslProtocol(String sslProtocol) {
        this.connector.setAttribute("SSLProtocol", (Object)sslProtocol);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCARevocationFile(String sslCARevocationFile) {
        if (sslCARevocationFile != null && sslCARevocationFile.equals("")) {
            sslCARevocationFile = null;
        }
        this.revocationFile = sslCARevocationFile;
        if (this.revocationFile == null) {
            this.connector.setAttribute("SSLCARevocationFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.revocationFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCARevocationFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslCARevocationPath(String sslCARevocationPath) {
        if (sslCARevocationPath != null && sslCARevocationPath.equals("")) {
            sslCARevocationPath = null;
        }
        this.revocationPath = sslCARevocationPath;
        if (this.revocationPath == null) {
            this.connector.setAttribute("SSLCARevocationPath", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.revocationPath);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("SSLCARevocationPath", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setSslVerifyClient(String sslVerifyClient) {
        this.connector.setAttribute("SSLVerifyClient", (Object)sslVerifyClient);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslVerifyDepth(int sslVerifyDepth) {
        this.connector.setAttribute("SSLVerifyDepth", (Object)sslVerifyDepth);
    }

    @Override
    @Persistent(manageable=false)
    public void setUseSendfile(boolean useSendfile) {
        this.connector.setAttribute("useSendfile", (Object)useSendfile);
    }
}

