/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatServerConfigManager;
import org.apache.geronimo.tomcat.model.ServerType;
import org.apache.tomcat.util.modeler.Registry;
import org.xml.sax.SAXException;

@GBean
public class TomcatServerGBean
implements GBeanLifecycle {
    public static final XMLInputFactory XMLINPUT_FACTORY = XMLInputFactory.newInstance();
    public static final JAXBContext SERVER_CONTEXT;
    private static final String DEFAULT_CATALINA_HOME = "var/catalina";
    public static final Map<Connector, String> ConnectorName;
    public static final List<LifecycleListener> LifecycleListeners;
    public static final Map<String, Executor> executors;
    private final String serverConfig;
    private final ClassLoader classLoader;
    private final ServerInfo serverInfo;
    private final Server server;
    private TomcatServerConfigManager tomcatServerConfigManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TomcatServerGBean(@ParamAttribute(name="serverConfig") String serverConfig, @ParamAttribute(name="serverConfigLocation") String serverConfigLocation, @ParamAttribute(name="catalinaHome") String catalinaHome, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamReference(name="AttributeManager", namingType="AttributeStore") PluginAttributeStore attributeStore, @ParamReference(name="MBeanServerReference") MBeanServerReference mbeanServerReference, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws Exception {
        this.serverConfig = serverConfig;
        this.serverInfo = serverInfo;
        this.classLoader = classLoader;
        if (mbeanServerReference != null) {
            Registry.getRegistry(null, null).setMBeanServer(mbeanServerReference.getMBeanServer());
        }
        if (catalinaHome == null) {
            catalinaHome = DEFAULT_CATALINA_HOME;
        }
        System.setProperty("catalina.home", serverInfo.resolveServerPath(catalinaHome));
        System.setProperty("catalina.base", serverInfo.resolveServerPath(catalinaHome));
        if (serverConfig == null) {
            int i;
            File serverConfigFile = serverInfo.resolveServer(serverConfigLocation);
            this.tomcatServerConfigManager = new TomcatServerConfigManager(serverConfigFile);
            FileReader in = new FileReader(serverConfigFile);
            StringBuilder b = new StringBuilder();
            char[] buf = new char[1024];
            while ((i = in.read(buf)) > 0) {
                b.append(buf, 0, i);
            }
            serverConfig = b.toString();
        }
        if (attributeStore != null) {
            serverConfig = attributeStore.substitute(serverConfig);
        }
        StringReader in = new StringReader(serverConfig);
        try {
            ServerType serverType = TomcatServerGBean.loadServerType(in);
            this.server = serverType.build(classLoader, kernel);
        }
        finally {
            ((Reader)in).close();
        }
    }

    static ServerType loadServerType(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = SERVER_CONTEXT.createUnmarshaller();
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        JAXBElement element = unmarshaller.unmarshal(xmlStream, ServerType.class);
        ServerType serverType = (ServerType)element.getValue();
        return serverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.server.init();
            this.server.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void doStop() throws Exception {
        this.server.stop();
        this.server.destroy();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Service getService(String serviceName) {
        Service service;
        if (serviceName == null) {
            Service[] services = this.server.findServices();
            if (services == null || services.length == 0) {
                throw new IllegalStateException("No services in server");
            }
            if (services.length > 1) {
                throw new IllegalStateException("More than one service in server.  Provide name of desired server" + Arrays.asList(services));
            }
            service = services[0];
        } else {
            service = this.server.findService(serviceName);
        }
        return service;
    }

    public TomcatServerConfigManager getTomcatServerConfigManager() {
        return this.tomcatServerConfigManager;
    }

    public Server getServer() {
        return this.server;
    }

    static {
        ConnectorName = new HashMap<Connector, String>();
        LifecycleListeners = new ArrayList<LifecycleListener>();
        executors = new HashMap<String, Executor>();
        try {
            SERVER_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ServerType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb contexts for plugin types", e);
        }
    }
}

