/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.security.AccessControlContext;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextConfig;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.geronimo.tomcat.security.authentication.BasicAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.ClientCertAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.DigestAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.FormAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.NoneAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicCallbackHandler;
import org.apache.geronimo.tomcat.security.impl.GeronimoIdentityService;
import org.apache.geronimo.tomcat.security.impl.GeronimoLoginService;
import org.apache.geronimo.tomcat.security.jacc.JACCAuthorizer;
import org.apache.geronimo.tomcat.security.jacc.JACCRealm;
import org.apache.geronimo.tomcat.security.jacc.JACCSecurityValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class BaseGeronimoContextConfig
extends ContextConfig {
    private static final String MESSAGE_LAYER = "HttpServlet";
    private static final String POLICY_CONTEXT_ID_KEY = "javax.security.jacc.PolicyContext";
    private static Log log = LogFactory.getLog(BaseGeronimoContextConfig.class);

    protected void configureSecurity(StandardContext geronimoContext, String policyContextId, ConfigurationFactory configurationFactory, Subject defaultSubject, String authMethod, String realmName, String loginPage, String errorPage) {
        Authenticator authenticator;
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        GeronimoIdentityService identityService = new GeronimoIdentityService(defaultSubject);
        UserIdentity unauthenticatedIdentity = identityService.newUserIdentity(defaultSubject, null, null);
        GeronimoLoginService loginService = new GeronimoLoginService(configurationFactory, identityService);
        AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
        RegistrationListener listener = new RegistrationListener(){

            public void notify(String layer, String appContext) {
            }
        };
        String appContext = "server " + geronimoContext.getPath();
        AuthConfigProvider authConfigProvider = authConfigFactory.getConfigProvider(MESSAGE_LAYER, appContext, listener);
        ServerAuthConfig serverAuthConfig = null;
        JaspicCallbackHandler callbackHandler = null;
        if (authConfigProvider != null) {
            callbackHandler = new JaspicCallbackHandler(loginService);
            try {
                serverAuthConfig = authConfigProvider.getServerAuthConfig(MESSAGE_LAYER, appContext, (CallbackHandler)callbackHandler);
            }
            catch (AuthException e) {
                // empty catch block
            }
        }
        if (serverAuthConfig != null) {
            HashMap<String, String> authProperties = new HashMap<String, String>();
            authProperties.put(POLICY_CONTEXT_ID_KEY, policyContextId);
            Subject serviceSubject = new Subject();
            authenticator = new JaspicAuthenticator(serverAuthConfig, authProperties, serviceSubject, callbackHandler, identityService);
        } else {
            authenticator = "BASIC".equalsIgnoreCase(authMethod) ? new BasicAuthenticator(loginService, realmName, unauthenticatedIdentity) : ("CLIENT-CERT".equalsIgnoreCase(authMethod) ? new ClientCertAuthenticator(loginService, unauthenticatedIdentity) : ("DIGEST".equalsIgnoreCase(authMethod) ? new DigestAuthenticator(loginService, realmName, unauthenticatedIdentity) : ("FORM".equalsIgnoreCase(authMethod) ? new FormAuthenticator(loginService, unauthenticatedIdentity, loginPage, errorPage) : new NoneAuthenticator(unauthenticatedIdentity))));
        }
        AccessControlContext defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null, null);
        Authorizer authorizer = this.createAuthorizer(defaultAcc);
        JACCSecurityValve securityValve = new JACCSecurityValve(authenticator, authorizer, identityService, policyContextId);
        geronimoContext.addValve((Valve)securityValve);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", new Object[]{authMethod}));
        }
        geronimoContext.setRealm((Realm)new JACCRealm());
    }

    protected Authorizer createAuthorizer(AccessControlContext defaultAcc) {
        return new JACCAuthorizer(defaultAcc);
    }

    protected void parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        super.parseWebXml(source, dest, fragment);
        dest.setMetadataComplete(true);
    }
}

