/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.impl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.realm.providers.CertificateChainCallbackHandler;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class GeronimoLoginService
implements LoginService {
    private final ConfigurationFactory configurationFactory;
    private final IdentityService identityService;

    public GeronimoLoginService(ConfigurationFactory configurationFactory, IdentityService identityService) {
        this.configurationFactory = configurationFactory;
        this.identityService = identityService;
    }

    public UserIdentity login(String userName, String password) {
        return this.login((CallbackHandler)new PasswordCallbackHandler(userName, password.toCharArray()));
    }

    public UserIdentity login(X509Certificate[] certs) {
        return this.login((CallbackHandler)new CertificateChainCallbackHandler((Certificate[])certs));
    }

    private UserIdentity login(CallbackHandler callbackHandler) {
        try {
            LoginContext loginContext = ContextManager.login((String)this.configurationFactory.getConfigurationName(), (CallbackHandler)callbackHandler, (Configuration)this.configurationFactory.getConfiguration());
            Subject establishedSubject = loginContext.getSubject();
            Principal userPrincipal = ContextManager.getCurrentPrincipal((Subject)establishedSubject);
            return this.identityService.newUserIdentity(establishedSubject, userPrincipal, null);
        }
        catch (LoginException e) {
            return null;
        }
    }

    public void logout(UserIdentity userIdentity) {
    }
}

