/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication.jaspic;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class JaspicCallbackHandler
implements CallbackHandler {
    private final LoginService loginService;
    private final ThreadLocal<CallerPrincipalCallback> callerPrincipals = new ThreadLocal();
    private final ThreadLocal<GroupPrincipalCallback> groupPrincipals = new ThreadLocal();

    public JaspicCallbackHandler(LoginService loginService) {
        this.loginService = loginService;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CallerPrincipalCallback) {
                this.callerPrincipals.set((CallerPrincipalCallback)callback);
                continue;
            }
            if (callback instanceof GroupPrincipalCallback) {
                this.groupPrincipals.set((GroupPrincipalCallback)callback);
                continue;
            }
            if (callback instanceof PasswordValidationCallback) {
                PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
                Subject subject = passwordValidationCallback.getSubject();
                UserIdentity user = this.loginService.login(passwordValidationCallback.getUsername(), new String(passwordValidationCallback.getPassword()));
                if (user == null) continue;
                passwordValidationCallback.setResult(true);
                passwordValidationCallback.getSubject().getPrincipals().addAll(user.getSubject().getPrincipals());
                passwordValidationCallback.getSubject().getPrivateCredentials().add(user);
                continue;
            }
            if (callback instanceof CertStoreCallback || callback instanceof PrivateKeyCallback || callback instanceof SecretKeyCallback || callback instanceof TrustStoreCallback) continue;
            throw new UnsupportedCallbackException(callback);
        }
    }

    public CallerPrincipalCallback getThreadCallerPrincipalCallback() {
        CallerPrincipalCallback callerPrincipalCallback = this.callerPrincipals.get();
        this.callerPrincipals.remove();
        return callerPrincipalCallback;
    }

    public GroupPrincipalCallback getThreadGroupPrincipalCallback() {
        GroupPrincipalCallback groupPrincipalCallback = this.groupPrincipals.get();
        this.groupPrincipals.remove();
        return groupPrincipalCallback;
    }
}

