/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardService;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.model.ConnectorType;
import org.apache.geronimo.tomcat.model.EngineType;
import org.apache.geronimo.tomcat.model.ExecutorType;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ServiceType", propOrder={"connector", "engine", "listener", "executor"})
public class ServiceType {
    @XmlElement(name="Connector")
    protected List<ConnectorType> connector;
    @XmlElement(name="Engine")
    protected EngineType engine;
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlElement(name="Executor")
    protected List<ExecutorType> executor;
    @XmlAttribute
    protected String className = StandardService.class.getName();
    @XmlAttribute
    protected String name;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<ConnectorType> getConnector() {
        if (this.connector == null) {
            this.connector = new ArrayList<ConnectorType>();
        }
        return this.connector;
    }

    public EngineType getEngine() {
        return this.engine;
    }

    public void setEngine(EngineType value) {
        this.engine = value;
    }

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public List<ExecutorType> getExecutor() {
        if (this.executor == null) {
            this.executor = new ArrayList<ExecutorType>();
        }
        return this.executor;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Service getService(ClassLoader cl, Kernel kernel) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", this.getName());
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Service service = (Service)recipe.create(cl);
        for (ExecutorType executorType : this.getExecutor()) {
            Executor executor = executorType.getExecutor(cl, kernel);
            service.addExecutor(executor);
            TomcatServerGBean.executors.put(executor.getName(), executor);
        }
        for (ConnectorType connectorType : this.getConnector()) {
            Connector connector = connectorType.getConnector(cl, service);
            service.addConnector(connector);
        }
        if (service instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)service;
            for (ListenerType listenerType : this.getListener()) {
                LifecycleListener listener = listenerType.getLifecycleListener(cl);
                lifecycle.addLifecycleListener(listener);
            }
        }
        if (this.getEngine() != null) {
            Engine engine = this.getEngine().getEngine(cl);
            service.setContainer((Container)engine);
        }
        return service;
    }
}

