/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.Stack;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.core.StandardWrapper;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.security.jacc.JACCRealm;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchListener
implements InstanceListener {
    private static final Logger log = LoggerFactory.getLogger(DispatchListener.class);
    private static ThreadLocal<Stack<Object[]>> currentContext = new ThreadLocal<Stack<Object[]>>(){

        @Override
        protected Stack<Object[]> initialValue() {
            return new Stack<Object[]>();
        }
    };

    public void instanceEvent(InstanceEvent event) {
        Container parent;
        if (event.getType().equals("beforeDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.beforeDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
        if (event.getType().equals("afterDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.afterDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
    }

    private void beforeDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack<Object[]> stack = currentContext.get();
            Object[] context = new Object[webContext.getContextCount() + 2];
            String wrapperName = this.getWrapperName(request, webContext);
            context[webContext.getContextCount()] = JACCRealm.setRequestWrapperName(wrapperName);
            context[webContext.getContextCount() + 1] = PolicyContext.getContextID();
            PolicyContext.setContextID((String)webContext.getPolicyContextId());
            beforeAfter.before(context, request, response, 1);
            stack.push(context);
        }
    }

    private void afterDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack<Object[]> stack = currentContext.get();
            Object[] context = stack.pop();
            beforeAfter.after(context, request, response, 1);
            JACCRealm.setRequestWrapperName((String)context[webContext.getContextCount()]);
            PolicyContext.setContextID((String)((String)context[webContext.getContextCount() + 1]));
        }
    }

    private String getWrapperName(ServletRequest request, GeronimoStandardContext webContext) {
        MappingData mappingData = new MappingData();
        Mapper mapper = webContext.getMapper();
        MessageBytes mb = MessageBytes.newInstance();
        String dispatchPath = (String)request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        mb.setString(webContext.getName() + dispatchPath);
        try {
            mapper.map(mb, mappingData);
            StandardWrapper wrapper = (StandardWrapper)mappingData.wrapper;
            return wrapper.getName();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

