/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.Container;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.Log;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatLogManager;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatLogManagerImpl
implements TomcatLogManager,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(TomcatLogManagerImpl.class);
    private static final Pattern FILENAME_DATE_PATTERN = Pattern.compile("[-_ /.](((19|20)\\d\\d)[-_ /.](0[1-9]|1[012])[-_ /.](0[1-9]|[12][0-9]|3[01]))");
    private static final int GROUP_FILENAME_FULL_DATE = 1;
    private static final int GROUP_FILENAME_YEAR = 2;
    private static final int GROUP_FILENAME_MONTH = 4;
    private static final int GROUP_FILENAME_DAY = 5;
    private static final String FILE_SEPARATOR_UNIX_STYLE = "/";
    private static final String FILE_SEPARATOR_WIN_STYLE = "\\";
    private static final Pattern FULL_LINE_PATTERN = Pattern.compile("^.*", 8);
    private static final Pattern ACCESS_LOG_PATTERN = Pattern.compile("(\\S*) (\\S*) (\\S*) \\[(.*)\\] \\\"(\\S*) (\\S*).*?\\\" (\\S*) (\\S*).*");
    private static final int GROUP_HOST = 1;
    private static final int GROUP_USER = 3;
    private static final int GROUP_DATE = 4;
    private static final int GROUP_METHOD = 5;
    private static final int GROUP_URI = 6;
    private static final int GROUP_RESPONSE_CODE = 7;
    private static final int GROUP_RESPONSE_LENGTH = 8;
    private static final String ACCESS_LOG_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss ZZZZ";
    private static final String LOG_FILE_NAME_FORMAT = "yyyy-MM-dd";
    private List<AccessLogValve> accessLogValves;
    private final ServerInfo serverInfo;
    private TomcatServerGBean tomcatServer;
    public static final GBeanInfo GBEAN_INFO;

    public TomcatLogManagerImpl(ServerInfo serverInfo, TomcatServerGBean tomcatServer) {
        this.serverInfo = serverInfo;
        this.tomcatServer = tomcatServer;
    }

    public String[] getLogNames() {
        ArrayList<String> logNames = new ArrayList<String>();
        for (AccessLogValve accessLogValve : this.accessLogValves) {
            logNames.add("var/catalina/logs/" + accessLogValve.getPrefix() + LOG_FILE_NAME_FORMAT + accessLogValve.getSuffix());
        }
        return logNames.toArray(new String[logNames.size()]);
    }

    public String[] getLogFileNames(String logName) {
        ArrayList<String> names = new ArrayList<String>();
        File[] logFiles = this.getLogFiles(logName);
        if (logFiles != null) {
            for (int i = 0; i < logFiles.length; ++i) {
                names.add(logFiles[i].getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private File[] getLogFiles(String logName) {
        File[] logFiles = null;
        try {
            String fileNamePattern = logName;
            if (fileNamePattern.indexOf(FILE_SEPARATOR_UNIX_STYLE) > -1) {
                fileNamePattern = fileNamePattern.substring(fileNamePattern.lastIndexOf(FILE_SEPARATOR_UNIX_STYLE) + 1);
            } else if (fileNamePattern.indexOf(FILE_SEPARATOR_WIN_STYLE) > -1) {
                fileNamePattern = fileNamePattern.substring(fileNamePattern.lastIndexOf(FILE_SEPARATOR_WIN_STYLE) + 1);
            }
            String logFile = this.serverInfo.resolveServerPath(logName);
            File parent = new File(logFile).getParentFile();
            if (parent != null) {
                logFiles = parent.listFiles(new PatternFilenameFilter(fileNamePattern));
            }
        }
        catch (Exception e) {
            log.error("Exception attempting to locate Tomcat log files", (Throwable)e);
            logFiles = new File[]{};
        }
        return logFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log.SearchResults getMatchingItems(String logName, String host, String user, String method, String uri, Date startDate, Date endDate, Integer skipResults, Integer maxResults) {
        if (host != null && host.equals("")) {
            host = null;
        }
        if (user != null && user.equals("")) {
            user = null;
        }
        if (method != null && method.equals("")) {
            method = null;
        }
        if (uri != null && uri.equals("")) {
            uri = null;
        }
        long start = startDate == null ? 0L : startDate.getTime();
        long end = endDate == null ? 0L : endDate.getTime();
        LinkedList<Log.LogMessage> list = new LinkedList<Log.LogMessage>();
        boolean capped = false;
        int lineCount = 0;
        int fileLineCount = 0;
        File[] logFiles = this.getLogFiles(logName);
        if (logFiles != null) {
            for (int i = 0; i < logFiles.length; ++i) {
                fileLineCount = 0;
                FileInputStream logInputStream = null;
                try {
                    String line;
                    int max;
                    String fileName = logFiles[i].getName();
                    Matcher fileDate = FILENAME_DATE_PATTERN.matcher(fileName);
                    fileDate.find();
                    SimpleDateFormat simpleFileDate = new SimpleDateFormat(LOG_FILE_NAME_FORMAT);
                    long logFileTime = simpleFileDate.parse(fileDate.group(1)).getTime();
                    if ((start != 0L || end != 0L) && (start <= 0L || start > logFileTime || end <= 0L || end < logFileTime)) continue;
                    logInputStream = new FileInputStream(logFiles[i]);
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)logInputStream, "US-ASCII"));
                    Matcher target = ACCESS_LOG_PATTERN.matcher("");
                    SimpleDateFormat format = start == 0L && end == 0L ? null : new SimpleDateFormat(ACCESS_LOG_DATE_FORMAT);
                    int n = max = maxResults == null ? 1000 : Math.min(maxResults, 1000);
                    while ((line = reader.readLine()) != null) {
                        ++lineCount;
                        ++fileLineCount;
                        if (capped) continue;
                        target.reset(line);
                        if (!target.find() || host != null && !host.equals(target.group(1)) || user != null && !user.equals(target.group(3)) || method != null && !method.equals(target.group(5)) || uri != null && !target.group(6).startsWith(uri)) continue;
                        if (format != null) {
                            try {
                                long entry = format.parse(target.group(4)).getTime();
                                if (start > entry || end > 0L && end < entry) {
                                    continue;
                                }
                            }
                            catch (ParseException e) {
                                // empty catch block
                            }
                        }
                        if (skipResults != null && skipResults > lineCount) continue;
                        if (list.size() > max) {
                            capped = true;
                            continue;
                        }
                        list.add(new Log.LogMessage(fileLineCount, line.toString()));
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("Unexpected error processing logs", (Throwable)e);
                    continue;
                }
                finally {
                    if (logInputStream != null) {
                        try {
                            logInputStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return new Log.SearchResults(lineCount, list.toArray(new Log.LogMessage[list.size()]), capped);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        Server server = this.tomcatServer.getServer();
        this.accessLogValves = new LinkedList<AccessLogValve>();
        for (Service service : server.findServices()) {
            Container container = service.getContainer();
            this.searchAccessLogValves(container);
        }
    }

    private void searchAccessLogValves(Container container) {
        Pipeline pipeline = container.getPipeline();
        if (pipeline == null) {
            return;
        }
        Valve[] valves = pipeline.getValves();
        if (valves == null || valves.length == 0) {
            return;
        }
        for (Valve valve : valves) {
            if (!(valve instanceof AccessLogValve)) continue;
            this.accessLogValves.add((AccessLogValve)valve);
        }
        Container[] subContainers = container.findChildren();
        if (subContainers != null && subContainers.length > 0) {
            for (Container subContainer : subContainers) {
                this.searchAccessLogValves(subContainer);
            }
        }
    }

    public void doStop() throws Exception {
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Log Manager", TomcatLogManagerImpl.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("Server", TomcatServerGBean.class);
        infoFactory.addInterface(TomcatLogManager.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "Server"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    static class PatternFilenameFilter
    implements FilenameFilter {
        Pattern pattern;

        PatternFilenameFilter(String fileNamePattern) {
            fileNamePattern = fileNamePattern.replaceAll("yyyy", "\\\\d{4}");
            fileNamePattern = fileNamePattern.replaceAll("yy", "\\\\d{2}");
            fileNamePattern = fileNamePattern.replaceAll("mm", "\\\\d{2}");
            fileNamePattern = fileNamePattern.replaceAll("MM", "\\\\d{2}");
            fileNamePattern = fileNamePattern.replaceAll("dd", "\\\\d{2}") + ".*";
            this.pattern = Pattern.compile(fileNamePattern);
        }

        public boolean accept(File file, String fileName) {
            return this.pattern.matcher(fileName).matches();
        }
    }
}

