/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11Protocol;

public abstract class AbstractHttp11ConnectorGBean
extends BaseHttp11ConnectorGBean
implements Http11Protocol {
    private String keystoreFileName;
    private String truststoreFileName;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public AbstractHttp11ConnectorGBean(String name, Map initParams, String tomcatProtocol, String host, int port, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        super(name, initParams, tomcatProtocol, host, port, container, serverInfo);
    }

    public int getDefaultPort() {
        return 80;
    }

    public String getGeronimoProtocol() {
        return "HTTP";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCiphers() {
        return (String)this.connector.getAttribute("ciphers");
    }

    public boolean getClientAuth() {
        Object value = this.connector.getAttribute("clientAuth");
        return value == null ? false : new Boolean(value.toString());
    }

    public String getKeyAlias() {
        return (String)this.connector.getAttribute("keyAlias");
    }

    public String getKeystoreFile() {
        return this.keystoreFileName;
    }

    public String getKeystoreType() {
        return (String)this.connector.getAttribute("keystoreType");
    }

    public String getSslProtocol() {
        return (String)this.connector.getAttribute("sslProtocol");
    }

    public String getTruststoreFile() {
        return this.truststoreFileName;
    }

    public String getTruststoreType() {
        return (String)this.connector.getAttribute("truststoreType");
    }

    public String getTruststorePass() {
        return (String)this.connector.getAttribute("truststorePass");
    }

    public String getKeystorePass() {
        return (String)this.connector.getAttribute("keystorePass");
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.connector.setAttribute("algorithm", (Object)algorithm);
    }

    public void setCiphers(String ciphers) {
        this.connector.setAttribute("ciphers", (Object)ciphers);
    }

    public void setClientAuth(boolean clientAuth) {
        this.connector.setAttribute("clientAuth", (Object)new Boolean(clientAuth));
    }

    public void setKeyAlias(String keyAlias) {
        if (keyAlias.equals("")) {
            keyAlias = null;
        }
        this.connector.setAttribute("keyAlias", (Object)keyAlias);
    }

    public void setKeystoreFile(String keystoreFile) {
        if (keystoreFile != null && keystoreFile.equals("")) {
            keystoreFile = null;
        }
        this.keystoreFileName = keystoreFile;
        if (this.keystoreFileName == null) {
            this.connector.setAttribute("keystoreFile", null);
        } else {
            this.connector.setAttribute("keystoreFile", (Object)this.serverInfo.resolveServerPath(this.keystoreFileName));
        }
    }

    public void setKeystorePass(String keystorePass) {
        if (keystorePass != null && keystorePass.equals("")) {
            keystorePass = null;
        }
        this.connector.setAttribute("keystorePass", (Object)keystorePass);
    }

    public void setKeystoreType(String keystoreType) {
        if (keystoreType != null && keystoreType.equals("")) {
            keystoreType = null;
        }
        this.connector.setAttribute("keystoreType", (Object)keystoreType);
    }

    public void setSslProtocol(String sslProtocol) {
        if (sslProtocol != null && sslProtocol.equals("")) {
            sslProtocol = null;
        }
        this.connector.setAttribute("sslProtocol", (Object)sslProtocol);
    }

    public void setTruststoreFile(String truststoreFile) {
        if (truststoreFile != null && truststoreFile.equals("")) {
            truststoreFile = null;
        }
        this.truststoreFileName = truststoreFile;
        if (this.truststoreFileName == null) {
            this.connector.setAttribute("truststoreFile", null);
        } else {
            this.connector.setAttribute("truststoreFile", (Object)this.serverInfo.resolveServerPath(this.truststoreFileName));
        }
    }

    public void setTruststorePass(String truststorePass) {
        if (truststorePass != null && truststorePass.equals("")) {
            truststorePass = null;
        }
        this.connector.setAttribute("truststorePass", (Object)truststorePass);
    }

    public void setTruststoreType(String truststoreType) {
        if (truststoreType != null && truststoreType.equals("")) {
            truststoreType = null;
        }
        this.connector.setAttribute("truststoreType", (Object)truststoreType);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", AbstractHttp11ConnectorGBean.class, (GBeanInfo)BaseHttp11ConnectorGBean.GBEAN_INFO);
        infoFactory.addInterface(Http11Protocol.class, new String[]{"algorithm", "clientAuth", "keystoreFile", "keystorePass", "keystoreType", "sslProtocol", "ciphers", "keyAlias", "truststoreFile", "truststorePass", "truststoreType"}, new String[]{"algorithm", "clientAuth", "keystoreFile", "keystorePass", "keystoreType", "sslProtocol", "ciphers", "keyAlias", "truststoreFile", "truststorePass", "truststoreType"});
        infoFactory.setConstructor(new String[]{"name", "initParams", "tomcatProtocol", "host", "port", "TomcatContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

