/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import org.apache.catalina.LifecycleListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;

public class LifecycleListenerGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Log log = LogFactory.getLog(LifecycleListenerGBean.class);
    public static final String J2EE_TYPE = "TomcatLifecycleListener";
    private final LifecycleListener listener;
    private final LifecycleListenerGBean nextListener;
    private final String className;
    public static final GBeanInfo GBEAN_INFO;

    public LifecycleListenerGBean() {
        this.listener = null;
        this.nextListener = null;
        this.className = null;
    }

    public LifecycleListenerGBean(String className, Map initParams, LifecycleListenerGBean nextListener) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null.");
        }
        if (nextListener != null) {
            if (!(nextListener.getInternalObject() instanceof LifecycleListener)) {
                throw new IllegalArgumentException("The class given as the NextListener attribute does not wrap an object of org.apache.catalina.LifecycleListener type.");
            }
            this.nextListener = nextListener;
        } else {
            this.nextListener = null;
        }
        this.className = className;
        this.listener = (LifecycleListener)Class.forName(className).newInstance();
        this.setParameters(this.listener, initParams);
    }

    public void doStart() throws Exception {
        log.debug((Object)(this.className + " started."));
    }

    public void doStop() throws Exception {
        log.debug((Object)(this.className + " stopped."));
    }

    public void doFail() {
        log.warn((Object)(this.className + " failed."));
    }

    public Object getInternalObject() {
        return this.listener;
    }

    public LifecycleListenerGBean getNextListener() {
        return this.nextListener;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(LifecycleListenerGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("NextListener", LifecycleListenerGBean.class, J2EE_TYPE);
        infoFactory.addOperation("getInternalObject");
        infoFactory.addOperation("getNextListener");
        infoFactory.setConstructor(new String[]{"className", "initParams", "NextListener"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

