/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatLogManager;
import org.apache.geronimo.tomcat.TomcatWebContainer;
import org.apache.geronimo.tomcat.connector.AJP13ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.TomcatWebConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatManagerImpl
implements WebManager {
    private static final Log log = LogFactory.getLog(TomcatManagerImpl.class);
    private final Kernel kernel;
    private static final WebManager.ConnectorType HTTP_BIO = new WebManager.ConnectorType("Tomcat BIO HTTP Connector");
    private static final WebManager.ConnectorType HTTPS_BIO = new WebManager.ConnectorType("Tomcat BIO HTTPS Connector");
    private static final WebManager.ConnectorType HTTP_NIO = new WebManager.ConnectorType("Tomcat NIO HTTP Connector");
    private static final WebManager.ConnectorType HTTPS_NIO = new WebManager.ConnectorType("Tomcat NIO HTTPS Connector");
    private static final WebManager.ConnectorType HTTP_APR = new WebManager.ConnectorType("Tomcat APR HTTP Connector");
    private static final WebManager.ConnectorType HTTPS_APR = new WebManager.ConnectorType("Tomcat APR HTTPS Connector");
    private static final WebManager.ConnectorType AJP = new WebManager.ConnectorType("Tomcat AJP Connector");
    private static List<WebManager.ConnectorType> CONNECTOR_TYPES = Arrays.asList(HTTP_BIO, HTTPS_BIO, HTTP_NIO, HTTPS_NIO, HTTP_APR, HTTPS_APR, AJP);
    private static Map<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>> CONNECTOR_ATTRIBUTES = new HashMap<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>>();
    private static Map<WebManager.ConnectorType, GBeanInfo> CONNECTOR_GBEAN_INFOS;
    public static final GBeanInfo GBEAN_INFO;

    public TomcatManagerImpl(Kernel kernel) {
        this.kernel = kernel;
    }

    public String getProductName() {
        return "Tomcat";
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new TomcatWebContainer[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (TomcatWebContainer)proxyManager.createProxy(name, TomcatWebContainer.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(AbstractName connectorName) {
        block11: {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
                boolean found = false;
                Set intfs = info.getInterfaces();
                for (String intf : intfs) {
                    if (!intf.equals(TomcatWebConnector.class.getName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new GBeanNotFoundException(connectorName);
                }
                EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
                if (mgr != null) {
                    try {
                        mgr.removeGBeanFromConfiguration(connectorName.getArtifact(), connectorName);
                        break block11;
                    }
                    catch (InvalidConfigException e) {
                        log.error((Object)"Unable to add GBean", (Throwable)e);
                        break block11;
                    }
                    finally {
                        ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
                    }
                }
                log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            }
            catch (GBeanNotFoundException e) {
                log.warn((Object)("No such GBean '" + connectorName + "'"));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        for (AbstractName name : names) {
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, TomcatWebConnector.class.getClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)"Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new TomcatWebConnector[names.size()]);
    }

    public WebAccessLog getAccessLog(WebContainer container) {
        AbstractNameQuery query = new AbstractNameQuery(TomcatLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Tomcat access log manager");
        }
        return (WebAccessLog)this.kernel.getProxyManager().createProxy((AbstractName)names.iterator().next(), TomcatLogManager.class.getClassLoader());
    }

    public List<WebManager.ConnectorType> getConnectorTypes() {
        return CONNECTOR_TYPES;
    }

    public List<WebManager.ConnectorAttribute> getConnectorAttributes(WebManager.ConnectorType connectorType) {
        return WebManager.ConnectorAttribute.copy(CONNECTOR_ATTRIBUTES.get(connectorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractName getConnectorConfiguration(WebManager.ConnectorType connectorType, List<WebManager.ConnectorAttribute> connectorAttributes, WebContainer container, String uniqueName) {
        GBeanInfo gbeanInfo = CONNECTOR_GBEAN_INFOS.get(connectorType);
        AbstractName containerName = this.kernel.getAbstractNameFor((Object)container);
        AbstractName name = this.kernel.getNaming().createSiblingName(containerName, uniqueName, "GBean");
        GBeanData gbeanData = new GBeanData(name, gbeanInfo);
        gbeanData.setAttribute("name", (Object)uniqueName);
        gbeanData.setReferencePattern("TomcatContainer", containerName);
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            gbeanData.setAttribute(connectorAttribute.getAttributeName(), connectorAttribute.getValue());
        }
        AbstractNameQuery query = new AbstractNameQuery(ServerInfo.class.getName());
        Set set = this.kernel.listGBeans(query);
        AbstractName serverInfo = (AbstractName)set.iterator().next();
        gbeanData.setReferencePattern("ServerInfo", serverInfo);
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            try {
                mgr.addGBeanToConfiguration(containerName.getArtifact(), gbeanData, false);
            }
            catch (InvalidConfigException e) {
                log.error((Object)"Unable to add GBean", (Throwable)e);
                AbstractName abstractName = null;
                return abstractName;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        } else {
            log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            return null;
        }
        return name;
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        NetworkConnector[] results = new TomcatWebConnector[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (TomcatWebConnector)proxyManager.createProxy(name, TomcatWebConnector.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectorsForContainer(Object container, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(container);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("TomcatContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, TomcatWebConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                }
                break;
            }
            return results.toArray(new TomcatWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Tomcat container '" + containerName + "': ").initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object container) {
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("TomcatContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, TomcatWebConnector.class.getClassLoader()));
            }
            return results.toArray(new TomcatWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Tomcat container '" + containerName).initCause(e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public WebManager.ConnectorType getConnectorType(AbstractName connectorName) {
        WebManager.ConnectorType connectorType = null;
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext() && !found) {
                String intf = (String)it.next();
                if (!intf.equals(TomcatWebConnector.class.getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(connectorName);
            }
            String searchingFor = info.getName();
            for (Map.Entry<WebManager.ConnectorType, GBeanInfo> entry : CONNECTOR_GBEAN_INFOS.entrySet()) {
                String candidate = entry.getValue().getName();
                if (!candidate.equals(searchingFor)) continue;
                return entry.getKey();
            }
        }
        catch (GBeanNotFoundException e) {
            log.warn((Object)("No such GBean '" + connectorName + "'"));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return connectorType;
    }

    static {
        ArrayList<WebManager.ConnectorAttribute> connectorAttributes = new ArrayList<WebManager.ConnectorAttribute>();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", (Object)"", "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8443, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreFile", (Object)"", "The file that holds the keystore (relative to the Geronimo install dir)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystorePass", null, "Set the password used to access the keystore file. This is also the password used to access the server private key within the keystore (so the two passwords must be set to be the same on the keystore).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreType", (Object)"JKS", "Set the keystore type. There is normally no reason not to use the default (JKS).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)KeyManagerFactory.getDefaultAlgorithm(), "Set the HTTPS algorithm. This should normally be set to match the JVM vendor.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuth", (Object)false, "clientAuth", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslProtocol", (Object)"TLS", "Set the HTTPS protocol. This should normally be set to TLS, though some (IBM) JVMs don't work properly with popular browsers unless it is changed to SSL.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("ciphers", (Object)"", "Ciphers", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyAlias", null, "keyAlias", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreFile", null, "The file that holds the truststore (relative to the Geronimo install dir)", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststorePass", null, "truststorePass", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreType", null, "Set the truststore type. There is normally no reason not to use the default (JKS).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        CONNECTOR_ATTRIBUTES.put(HTTPS_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, "useSendfile", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useExecutor", (Object)true, "useExecutor", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadCount", (Object)1, "acceptorThreadCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadCount", (Object)1, "pollerThreadCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadPriority", (Object)5, "pollerThreadPriority", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadPriority", (Object)5, "acceptorThreadPriority", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorTimeout", (Object)1000, "selectorTimeout", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useComet", (Object)true, "useComet", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("processCache", (Object)200, "processCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_directBuffer", (Object)false, "socket_directBuffer", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_rxBufSize", (Object)25188, "socket_rxBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_txBufSize", (Object)43800, "socket_txBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appReadBufSize", (Object)8192, "socket_appReadBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appWriteBufSize", (Object)8192, "socket_appWriteBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_processorCache", (Object)500, "socket_processorCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_bufferPoolSize", (Object)0x6400000, "socket_bufferPoolSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_keyCache", (Object)500, "socket_keyCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_eventCache", (Object)500, "socket_eventCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_tcpNoDelay", (Object)false, "socket_tcpNoDelay", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soKeepAlive", (Object)false, "socket_soKeepAlive", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_ooBInline", (Object)true, "socket_ooBInline", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soReuseAddress", (Object)false, "socket_soReuseAddress", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerOn", (Object)true, "socket_soLingerOn", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerTime", (Object)25, "socket_soLingerTime", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTimeout", (Object)5000, "socket_soTimeout", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTrafficClass", (Object)28, "socket_soTrafficClass", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceConnectionTime", (Object)1, "socket_performanceConnectionTime", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceLatency", (Object)0, "socket_performanceLatency", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceBandwidth", (Object)1, "socket_performanceBandwidth", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSelectors", (Object)200, "selectorPool_maxSelectors", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSpareSelectors", (Object)-1, "selectorPool_maxSpareSelectors", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("command_line_options", (Object)true, "command_line_options", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("oomParachute", (Object)0x100000, "oomParachute", Integer.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8443, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreFile", (Object)"", "The file that holds the keystore (relative to the Geronimo install dir)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystorePass", null, "Set the password used to access the keystore file. This is also the password used to access the server private key within the keystore (so the two passwords must be set to be the same on the keystore).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreType", (Object)"JKS", "Set the keystore type. There is normally no reason not to use the default (JKS).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)KeyManagerFactory.getDefaultAlgorithm(), "Set the HTTPS algorithm. This should normally be set to match the JVM vendor.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuth", (Object)false, "clientAuth", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslProtocol", (Object)"TLS", "Set the HTTPS protocol. This should normally be set to TLS, though some (IBM) JVMs don't work properly with popular browsers unless it is changed to SSL.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("ciphers", (Object)"", "Ciphers", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyAlias", null, "keyAlias", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreFile", null, "The file that holds the truststore (relative to the Geronimo install dir)", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststorePass", null, "truststorePass", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreType", null, "Set the truststore type. There is normally no reason not to use the default (JKS).", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, "useSendfile", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useExecutor", (Object)true, "useExecutor", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadCount", (Object)1, "acceptorThreadCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadCount", (Object)1, "pollerThreadCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadPriority", (Object)5, "pollerThreadPriority", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadPriority", (Object)5, "acceptorThreadPriority", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorTimeout", (Object)1000, "selectorTimeout", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useComet", (Object)true, "useComet", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("processCache", (Object)200, "processCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_directBuffer", (Object)false, "socket_directBuffer", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_rxBufSize", (Object)25188, "socket_rxBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_txBufSize", (Object)43800, "socket_txBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appReadBufSize", (Object)8192, "socket_appReadBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appWriteBufSize", (Object)8192, "socket_appWriteBufSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_processorCache", (Object)500, "socket_processorCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_bufferPoolSize", (Object)0x6400000, "socket_bufferPoolSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_keyCache", (Object)500, "socket_keyCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_eventCache", (Object)500, "socket_eventCache", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_tcpNoDelay", (Object)false, "socket_tcpNoDelay", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soKeepAlive", (Object)false, "socket_soKeepAlive", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_ooBInline", (Object)true, "socket_ooBInline", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soReuseAddress", (Object)false, "socket_soReuseAddress", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerOn", (Object)true, "socket_soLingerOn", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerTime", (Object)25, "socket_soLingerTime", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTimeout", (Object)5000, "socket_soTimeout", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTrafficClass", (Object)28, "socket_soTrafficClass", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceConnectionTime", (Object)1, "socket_performanceConnectionTime", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceLatency", (Object)0, "socket_performanceLatency", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceBandwidth", (Object)1, "socket_performanceBandwidth", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSelectors", (Object)200, "selectorPool_maxSelectors", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSpareSelectors", (Object)-1, "selectorPool_maxSpareSelectors", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("command_line_options", (Object)true, "command_line_options", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("oomParachute", (Object)0x100000, "oomParachute", Integer.class));
        CONNECTOR_ATTRIBUTES.put(HTTPS_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollTime", (Object)2000, "Duration of a poll call. Lowering this value will slightly decrease latency of connections being kept alive in some cases, but will use more CPU as more poll calls are being made.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerSize", (Object)8192, "Amount of sockets that the poller responsible for polling kept alive connections can hold at a given time.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, "Use kernel level sendfile for certain static files.", Boolean.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sendfileSize", (Object)1024, "Amount of sockets that the poller responsible for sending static files asynchronously can hold at a given time.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_APR, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8443, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollTime", (Object)2000, "Duration of a poll call. Lowering this value will slightly decrease latency of connections being kept alive in some cases, but will use more CPU as more poll calls are being made.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerSize", (Object)8192, "Amount of sockets that the poller responsible for polling kept alive connections can hold at a given time.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, "Use kernel level sendfile for certain static files.", Boolean.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sendfileSize", (Object)1024, "Amount of sockets that the poller responsible for sending static files asynchronously can hold at a given time.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, "acceptCount", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, "connectionLinger", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", "compressableMimeType", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", "compression", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, "disableUploadTimeout", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, "Maximum HTTP header size in bytes", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, "Maximum keep alive requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which compression should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", "Comma separated list of regular expressions matching user-agents for which which HTTP/1.1 or HTTP/1.0 keep alive should not be used", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, "The Server header for the http response.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, "The size (in bytes) of the buffer to be provided for socket output buffering", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, "The priority of the request processing threads within the JVM", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateFile", (Object)"", "Name of the file that contains the server certificate. The format is PEM-encoded.", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslPassword", null, "Pass phrase for the encrypted private key.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslProtocol", (Object)"all", "Protocol which may be used for communicating with clients.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCipherSuite", (Object)"ALL", "Ciphers which may be used for communicating with clients.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateKeyFile", null, "Name of the file that contains the server private key.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslVerifyClient", (Object)"none", "Ask client for certificate.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslVerifyDepth", (Object)10, "Maximum verification depth for client certificates.", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCACertificateFile", null, "File of concatenated PEM-encoded CA Certificates for Client Auth.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCACertificatePath", null, "Directory of PEM-encoded CA Certificates for Client Auth.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateChainFile", null, "File of PEM-encoded Server CA Certificates.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCARevocationFile", null, "File of concatenated PEM-encoded CA CRLs for Client Auth.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCARevocationPath", null, "Directory of PEM-encoded CA CRLs for Client Auth.", String.class));
        CONNECTOR_ATTRIBUTES.put(HTTPS_APR, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8009, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("backlog", (Object)10, "The maximum queue length for incoming connection requests when all possible request processing threads are in use.", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)-1, "Connection timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)-1, "Keep alive timeout in milliseconds", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, "Minimum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, "Maximum spare threads", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, "If set to true, the TCP_NO_DELAY option will be set on the server socket, which improves performance under most circumstances.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tomcatAuthentication", (Object)true, "If set to true, the authetication will be done in Geronimo. Otherwise, the authenticated principal will be propagated from the native webaserver and used for authorization in Geronimo.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, "Used to enable or disable the TRACE HTTP method.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, "emptySessionPath", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, "enableLookups", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, "maxPostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, "maxSavePostSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, "proxyName", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, "proxyPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", "uriEncoding", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, "useBodyEncodingForURI", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, "useIPVHosts", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, "xpoweredBy", Boolean.class));
        CONNECTOR_ATTRIBUTES.put(AJP, connectorAttributes);
        CONNECTOR_GBEAN_INFOS = new HashMap<WebManager.ConnectorType, GBeanInfo>();
        CONNECTOR_GBEAN_INFOS.put(HTTP_BIO, Http11ConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_BIO, Https11ConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_NIO, Http11NIOConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_NIO, Https11NIOConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_APR, Http11APRConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_APR, Https11APRConnectorGBean.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(AJP, AJP13ConnectorGBean.GBEAN_INFO);
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Web Manager", TomcatManagerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(WebManager.class);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

