/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.timer.ExecutorTask;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.ThreadPooledTimer;
import org.apache.geronimo.timer.WorkInfo;

public class NontransactionalExecutorTask
implements ExecutorTask {
    private static final Log log = LogFactory.getLog(NontransactionalExecutorTask.class);
    private final Runnable userTask;
    private final WorkInfo workInfo;
    private final ThreadPooledTimer threadPooledTimer;

    public NontransactionalExecutorTask(Runnable userTask, WorkInfo workInfo, ThreadPooledTimer threadPooledTimer) {
        this.userTask = userTask;
        this.workInfo = workInfo;
        this.threadPooledTimer = threadPooledTimer;
    }

    public void run() {
        try {
            this.userTask.run();
        }
        catch (Exception e) {
            log.warn((Object)"Exception running task", (Throwable)e);
        }
        try {
            this.threadPooledTimer.workPerformed(this.workInfo);
        }
        catch (PersistenceException e) {
            log.warn((Object)"Exception completing task", (Throwable)e);
        }
        if (this.workInfo.isOneTime()) {
            this.threadPooledTimer.removeWorkInfo(this.workInfo);
        }
    }
}

