/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.timer.ExecutorTask;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.ThreadPooledTimer;
import org.apache.geronimo.timer.WorkInfo;

public class TransactionalExecutorTask
implements ExecutorTask {
    private static final Log log = LogFactory.getLog(TransactionalExecutorTask.class);
    private final Runnable userTask;
    private final WorkInfo workInfo;
    private final ThreadPooledTimer threadPooledTimer;
    private final TransactionManager transactionManager;
    private final int repeatCount;

    public TransactionalExecutorTask(Runnable userTask, WorkInfo workInfo, ThreadPooledTimer threadPooledTimer, TransactionManager transactionManager, int repeatCount) {
        this.userTask = userTask;
        this.workInfo = workInfo;
        this.threadPooledTimer = threadPooledTimer;
        this.transactionManager = transactionManager;
        this.repeatCount = repeatCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean succeeded = false;
            for (int tries = 0; !succeeded && tries < this.repeatCount; ++tries) {
                try {
                    if (!this.beginWork()) break;
                    this.work();
                    continue;
                }
                finally {
                    succeeded = this.completeWork();
                }
            }
            if (this.workInfo.isOneTime()) {
                this.threadPooledTimer.removeWorkInfo(this.workInfo);
            }
            if (!succeeded) {
                log.warn((Object)"Failed to execute work successfully");
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)"RuntimeException occured while running user task", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.warn((Object)"Error occured while running user task", (Throwable)e);
            throw e;
        }
    }

    private boolean beginWork() {
        try {
            this.transactionManager.begin();
        }
        catch (Exception e) {
            log.warn((Object)"Exception occured while starting container transaction", (Throwable)e);
            return false;
        }
        return true;
    }

    private void work() {
        try {
            this.userTask.run();
        }
        catch (Exception e) {
            log.warn((Object)"Exception occured while running user task", (Throwable)e);
        }
    }

    private boolean completeWork() {
        try {
            if (this.transactionManager.getStatus() == 0) {
                try {
                    this.threadPooledTimer.workPerformed(this.workInfo);
                }
                catch (PersistenceException e) {
                    log.warn((Object)"Exception occured while updating timer persistent state", (Throwable)e);
                }
                this.transactionManager.commit();
                return true;
            }
            this.transactionManager.rollback();
        }
        catch (Exception e) {
            log.warn((Object)"Exception occured while completing container transaction", (Throwable)e);
        }
        return false;
    }
}

