/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ServerInfoRootResolver {
    private final ServerInfo serverInfo;
    private final boolean resolveToServer;

    public ServerInfoRootResolver(ServerInfo serverInfo, boolean resolveToServer) {
        this.serverInfo = serverInfo;
        this.resolveToServer = resolveToServer;
    }

    public File resolve(URI root) {
        URI resolvedUri;
        if (root == null) {
            throw new NullPointerException("root is null");
        }
        if (!root.toString().endsWith("/")) {
            try {
                root = new URI(root.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid repository root (does not end with / ) and can't add myself", e);
            }
        }
        if (!(resolvedUri = this.serverInfo != null ? (this.resolveToServer ? this.serverInfo.resolveServer(root) : this.serverInfo.resolve(root)) : root).getScheme().equals("file")) {
            throw new IllegalStateException("FileSystemRepository must have a root that's a local directory (not " + resolvedUri + ")");
        }
        File rootFile = new File(resolvedUri);
        return rootFile;
    }
}

