/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.GBeanOverride;

public class PluginMetadata
implements Serializable,
Comparable {
    private final String name;
    private final Artifact moduleId;
    private final String category;
    private final String description;
    private final String pluginURL;
    private final String author;
    private License[] licenses = new License[0];
    private final Hash hash;
    private geronimoVersions[] geronimoVersions = new geronimoVersions[0];
    private String[] jvmVersions = new String[0];
    private Prerequisite[] prerequisites = new Prerequisite[0];
    private String[] dependencies = new String[0];
    private String[] forceStart = new String[0];
    private String[] obsoletes = new String[0];
    private URL[] repositories = new URL[0];
    private CopyFile[] filesToCopy = new CopyFile[0];
    private GBeanOverride[] configXmls = new GBeanOverride[0];
    private final boolean installed;
    private final boolean eligible;

    public PluginMetadata(String name, Artifact moduleId, String category, String description, String pluginURL, String author, Hash hash, boolean installed, boolean eligible) {
        this.name = name;
        this.moduleId = moduleId;
        this.category = category;
        this.description = description;
        this.pluginURL = pluginURL;
        this.author = author;
        this.hash = hash;
        this.installed = installed;
        this.eligible = eligible;
    }

    public void setDependencies(String[] dependencies) {
        this.dependencies = dependencies;
    }

    public void setObsoletes(String[] obsoletes) {
        this.obsoletes = obsoletes;
    }

    public void setForceStart(String[] forceStart) {
        this.forceStart = forceStart;
    }

    public Artifact getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHTMLDescription() {
        String[] paras = PluginMetadata.splitParas(this.description);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < paras.length; ++i) {
            String para = paras[i];
            buf.append("<p>").append(para).append("</p>\n");
        }
        return buf.toString();
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String getVersion() {
        return this.moduleId.getVersion() == null ? "unknown version" : this.moduleId.getVersion().toString();
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public String[] getObsoletes() {
        return this.obsoletes;
    }

    public String[] getForceStart() {
        return this.forceStart;
    }

    public geronimoVersions[] getGeronimoVersions() {
        return this.geronimoVersions;
    }

    public String getAuthor() {
        return this.author;
    }

    public Hash getHash() {
        return this.hash;
    }

    public String getPluginURL() {
        return this.pluginURL;
    }

    public URL[] getRepositories() {
        return this.repositories;
    }

    public void setGeronimoVersions(geronimoVersions[] geronimoVersions2) {
        this.geronimoVersions = geronimoVersions2;
    }

    public License[] getLicenses() {
        return this.licenses;
    }

    public void setLicenses(License[] licenses) {
        this.licenses = licenses;
    }

    public String[] getJvmVersions() {
        return this.jvmVersions;
    }

    public void setJvmVersions(String[] jdkVersions) {
        this.jvmVersions = jdkVersions;
    }

    public Prerequisite[] getPrerequisites() {
        return this.prerequisites;
    }

    public void setRepositories(URL[] repositories) {
        this.repositories = repositories;
    }

    public void setPrerequisites(Prerequisite[] prerequisites) {
        this.prerequisites = prerequisites;
    }

    public boolean isEligible() {
        return this.eligible;
    }

    public CopyFile[] getFilesToCopy() {
        return this.filesToCopy;
    }

    public void setFilesToCopy(CopyFile[] filesToCopy) {
        this.filesToCopy = filesToCopy;
    }

    public GBeanOverride[] getConfigXmls() {
        return this.configXmls;
    }

    public void setConfigXmls(GBeanOverride[] configXmls) {
        this.configXmls = configXmls;
    }

    public int compareTo(Object o) {
        PluginMetadata other = (PluginMetadata)o;
        int test = this.category.compareTo(other.category);
        if (test != 0) {
            return test;
        }
        test = this.name.compareTo(other.name);
        return test;
    }

    private static String[] splitParas(String desc) {
        int start = 0;
        int last = 0;
        ArrayList<String> list = new ArrayList<String>();
        boolean inSpace = false;
        boolean multiple = false;
        for (int i = 0; i < desc.length(); ++i) {
            char d;
            int j;
            char c = desc.charAt(i);
            if (inSpace) {
                if (Character.isWhitespace(c)) {
                    if (c != '\r' && c != '\n') continue;
                    multiple = true;
                    j = i + 1;
                    while (j < desc.length() && (d = desc.charAt(j)) != c && (d == '\r' || d == '\n')) {
                        i = j++;
                    }
                    continue;
                }
                if (multiple) {
                    list.add(desc.substring(last, start).trim());
                    last = i;
                }
                inSpace = false;
                continue;
            }
            if (c != '\r' && c != '\n') continue;
            inSpace = true;
            multiple = false;
            start = i;
            j = i + 1;
            while (j < desc.length() && (d = desc.charAt(j)) != c && (d == '\r' || d == '\n')) {
                i = j++;
            }
        }
        if (last < desc.length()) {
            list.add(desc.substring(last).trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static class geronimoVersions
    implements Serializable {
        private String version;
        private String moduleId;
        private String[] repository;
        private Prerequisite[] preReqs;

        public geronimoVersions(String version, String moduleId, String[] repository, Prerequisite[] preReqs) {
            this.version = version;
            this.moduleId = moduleId;
            this.repository = repository;
            this.preReqs = preReqs;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String ver) {
            this.version = ver;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String[] getRepository() {
            return this.repository;
        }

        public Prerequisite[] getPreReqs() {
            return this.preReqs;
        }

        public void setPreReqs(Prerequisite[] prereqs) {
            this.preReqs = prereqs;
        }
    }

    public static class Prerequisite
    implements Serializable {
        private final Artifact moduleId;
        private final String resourceType;
        private final String description;
        private final boolean present;

        public Prerequisite(Artifact moduleId, boolean present) {
            this.moduleId = moduleId;
            this.present = present;
            this.resourceType = null;
            this.description = null;
        }

        public Prerequisite(Artifact moduleId, boolean present, String resourceType, String description) {
            this.moduleId = moduleId;
            this.present = present;
            this.resourceType = resourceType;
            this.description = description;
        }

        public Artifact getModuleId() {
            return this.moduleId;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPresent() {
            return this.present;
        }

        public String getModuleIdWithStars() {
            StringBuffer buf = new StringBuffer();
            if (this.moduleId.getGroupId() == null) {
                buf.append("*");
            } else {
                buf.append(this.moduleId.getGroupId());
            }
            buf.append("/");
            if (this.moduleId.getArtifactId() == null) {
                buf.append("*");
            } else {
                buf.append(this.moduleId.getArtifactId());
            }
            buf.append("/");
            if (this.moduleId.getVersion() == null) {
                buf.append("*");
            } else {
                buf.append(this.moduleId.getVersion());
            }
            buf.append("/");
            if (this.moduleId.getType() == null) {
                buf.append("*");
            } else {
                buf.append(this.moduleId.getType());
            }
            return buf.toString();
        }
    }

    public static class CopyFile
    implements Serializable {
        private final boolean relativeToServer;
        private final String sourceFile;
        private final String destDir;

        public CopyFile(boolean relativeToServer, String sourceFile, String destDir) {
            this.relativeToServer = relativeToServer;
            this.sourceFile = sourceFile;
            this.destDir = destDir;
        }

        public boolean isRelativeToServer() {
            return this.relativeToServer;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getDestDir() {
            return this.destDir;
        }
    }

    public static class Hash
    implements Serializable {
        private final String type;
        private final String value;

        public Hash(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class License
    implements Serializable {
        private final String name;
        private final boolean osiApproved;

        public License(String name, boolean osiApproved) {
            this.name = name;
            this.osiApproved = osiApproved;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOsiApproved() {
            return this.osiApproved;
        }
    }
}

