/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.deployment.service.XmlReferenceBuilder;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xbeans.ReferenceType;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.xmlbeans.XmlObject;

public class SingleGBeanBuilder {
    private final GBeanData gbean;
    private final ClassLoader classLoader;
    private final DeploymentContext context;
    private final AbstractName moduleName;
    private final Map xmlAttributeBuilderMap;
    private final Map xmlReferenceBuilderMap;

    SingleGBeanBuilder(AbstractName abstractName, GBeanInfo gBeanInfo, ClassLoader classLoader, DeploymentContext context, AbstractName moduleName, Map xmlAttributeBuilderMap, Map xmlReferenceBuilderMap) {
        this.classLoader = classLoader;
        this.context = context;
        this.moduleName = moduleName;
        this.gbean = new GBeanData(abstractName, gBeanInfo);
        this.xmlAttributeBuilderMap = xmlAttributeBuilderMap;
        this.xmlReferenceBuilderMap = xmlReferenceBuilderMap;
    }

    public void setAttribute(String name, String type, String text) throws DeploymentException {
        if (text != null) {
            text = text.trim();
        }
        try {
            PropertyEditor editor;
            if (type == null) {
                GAttributeInfo attribute = this.gbean.getGBeanInfo().getAttribute(name);
                if (attribute == null) {
                    throw new DeploymentException("Unknown attribute " + name + " on " + this.gbean.getAbstractName());
                }
                type = attribute.getType();
            }
            if ((editor = PropertyEditors.findEditor((String)type, (ClassLoader)this.classLoader)) == null) {
                throw new DeploymentException("Unable to find PropertyEditor for " + type);
            }
            editor.setAsText(text);
            Object value = editor.getValue();
            this.gbean.setAttribute(name, value);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to find PropertyEditor for " + type, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to set attribute " + name + " to " + text, (Throwable)e);
        }
    }

    public void setXmlAttribute(String name, XmlObject xmlObject) throws DeploymentException {
        String namespace = xmlObject.getDomNode().getNamespaceURI();
        XmlAttributeBuilder builder = (XmlAttributeBuilder)this.xmlAttributeBuilderMap.get(namespace);
        if (builder == null) {
            throw new DeploymentException("No attribute builder deployed for namespace: " + namespace);
        }
        GAttributeInfo attribute = this.gbean.getGBeanInfo().getAttribute(name);
        if (attribute == null) {
            throw new DeploymentException("Unknown attribute " + name + " on " + this.gbean.getAbstractName());
        }
        String type = attribute.getType();
        Object value = builder.getValue(xmlObject, type, this.classLoader);
        this.gbean.setAttribute(name, value);
    }

    public void setXmlReference(String name, XmlObject xmlObject) throws DeploymentException {
        String namespace = xmlObject.getDomNode().getNamespaceURI();
        XmlReferenceBuilder builder = (XmlReferenceBuilder)this.xmlReferenceBuilderMap.get(namespace);
        if (builder == null) {
            throw new DeploymentException("No reference builder deployed for namespace: " + namespace);
        }
        ReferencePatterns references = builder.getReferences(xmlObject, this.context, this.moduleName, this.classLoader);
        if (references != null) {
            this.gbean.setReferencePatterns(name, references);
        }
    }

    public void setReference(String name, ReferenceType pattern, AbstractName parentName) throws DeploymentException {
        this.setReference(name, new PatternType[]{pattern}, parentName);
    }

    public void setReference(String name, PatternType[] patterns, AbstractName parentName) throws DeploymentException {
        HashSet<AbstractNameQuery> patternNames = new HashSet<AbstractNameQuery>(patterns.length);
        for (int i = 0; i < patterns.length; ++i) {
            patternNames.add(this.buildAbstractNameQuery(name, patterns[i]));
        }
        this.gbean.setReferencePatterns(name, patternNames);
    }

    public void addDependency(PatternType patternType) throws DeploymentException {
        AbstractNameQuery refInfo = SingleGBeanBuilder.buildAbstractNameQuery(patternType, null);
        this.gbean.addDependency(refInfo);
    }

    private AbstractNameQuery buildAbstractNameQuery(String refName, PatternType pattern) throws DeploymentException {
        assert (refName != null);
        GReferenceInfo referenceInfo = null;
        Set referenceInfos = this.gbean.getGBeanInfo().getReferences();
        for (GReferenceInfo testReferenceInfo : referenceInfos) {
            String testRefName = testReferenceInfo.getName();
            if (!testRefName.equals(refName)) continue;
            referenceInfo = testReferenceInfo;
        }
        if (referenceInfo == null) {
            throw new DeploymentException("No reference named " + refName + " in gbean " + this.gbean.getAbstractName());
        }
        return SingleGBeanBuilder.buildAbstractNameQuery(pattern, referenceInfo);
    }

    public static AbstractNameQuery buildAbstractNameQuery(PatternType pattern, GReferenceInfo referenceInfo) {
        String nameTypeName = referenceInfo == null ? null : referenceInfo.getNameTypeName();
        Set<String> interfaceTypes = referenceInfo == null ? null : Collections.singleton(referenceInfo.getReferenceType());
        return SingleGBeanBuilder.buildAbstractNameQuery(pattern, nameTypeName, interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(PatternType pattern, String nameTypeName, Set interfaceTypes) {
        Artifact artifact;
        String groupId = pattern.isSetGroupId() ? pattern.getGroupId().trim() : null;
        String artifactid = pattern.isSetArtifactId() ? pattern.getArtifactId().trim() : null;
        String version = pattern.isSetVersion() ? pattern.getVersion().trim() : null;
        String module = pattern.isSetModule() ? pattern.getModule().trim() : null;
        String type = pattern.isSetType() ? pattern.getType().trim() : null;
        String name = pattern.isSetName() ? pattern.getName().trim() : null;
        Artifact artifact2 = artifact = artifactid != null ? new Artifact(groupId, artifactid, version, "car") : null;
        if (type == null) {
            type = nameTypeName;
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (name != null) {
            nameMap.put("name", name);
        }
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null) {
            nameMap.put("J2EEModule", module);
        }
        return new AbstractNameQuery(artifact, nameMap, interfaceTypes);
    }

    public GBeanData getGBeanData() {
        return this.gbean;
    }
}

