/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.ModuleDocument;
import org.apache.geronimo.deployment.xbeans.ModuleType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ServiceConfigBuilder
implements ConfigurationBuilder {
    private final Environment defaultEnvironment;
    private final Collection repositories;
    private static final QName MODULE_QNAME = ModuleDocument.type.getDocumentElementName();
    public static final String SERVICE_MODULE = "ServiceModule";
    private final Naming naming;
    private final ConfigurationManager configurationManager;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    public static final GBeanInfo GBEAN_INFO;

    public ServiceConfigBuilder(Environment defaultEnvironment, Collection repositories, Naming naming) {
        this(defaultEnvironment, repositories, Collections.EMPTY_LIST, naming, null);
    }

    public ServiceConfigBuilder(Environment defaultEnvironment, Collection repositories, Collection serviceBuilders, Kernel kernel) {
        this(defaultEnvironment, repositories, serviceBuilders, kernel.getNaming(), ConfigurationUtil.getConfigurationManager((Kernel)kernel));
    }

    public ServiceConfigBuilder(Environment defaultEnvironment, Collection repositories, Collection serviceBuilders, Naming naming) {
        this(defaultEnvironment, repositories, serviceBuilders, naming, null);
    }

    private ServiceConfigBuilder(Environment defaultEnvironment, Collection repositories, Collection serviceBuilders, Naming naming, ConfigurationManager configurationManager) {
        this.naming = naming;
        this.configurationManager = configurationManager;
        EnvironmentBuilder environmentBuilder = new EnvironmentBuilder();
        this.defaultEnvironment = defaultEnvironment;
        this.repositories = repositories;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, GBeanBuilder.SERVICE_QNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDeploymentPlan(File planFile, JarFile jarFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        try {
            String name;
            int pos;
            XmlObject xmlObject;
            if (planFile != null) {
                xmlObject = XmlBeansUtil.parse((URL)planFile.toURL(), (ClassLoader)this.getClass().getClassLoader());
            } else {
                URL path = DeploymentUtil.createJarURL((JarFile)jarFile, (String)"META-INF/geronimo-service.xml");
                try {
                    xmlObject = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            if (xmlObject == null) {
                return null;
            }
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toFirstChild();
                if (!MODULE_QNAME.equals(cursor.getName())) {
                    Object e = null;
                    return e;
                }
            }
            finally {
                cursor.dispose();
            }
            ModuleDocument moduleDoc = xmlObject instanceof ModuleDocument ? (ModuleDocument)xmlObject : (ModuleDocument)xmlObject.changeType(ModuleDocument.type);
            XmlBeansUtil.validateDD((XmlObject)moduleDoc);
            if (jarFile != null) return moduleDoc.getModule();
            if (moduleDoc.getModule().getEnvironment() != null && moduleDoc.getModule().getEnvironment().getModuleId() != null) {
                if (moduleDoc.getModule().getEnvironment().getModuleId().getArtifactId() != null) return moduleDoc.getModule();
            }
            if (moduleDoc.getModule().getEnvironment() == null) {
                moduleDoc.getModule().addNewEnvironment();
            }
            if (moduleDoc.getModule().getEnvironment().getModuleId() == null) {
                moduleDoc.getModule().getEnvironment().addNewModuleId();
            }
            if ((pos = (name = planFile.getName()).lastIndexOf(46)) > -1) {
                name = name.substring(0, pos);
            }
            moduleDoc.getModule().getEnvironment().getModuleId().setArtifactId(name);
            return moduleDoc.getModule();
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse xml in plan", (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("no plan at " + planFile, (Throwable)e);
        }
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        ModuleType configType = (ModuleType)plan;
        EnvironmentType environmentType = configType.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment(environmentType, this.defaultEnvironment);
        idBuilder.resolve(environment, module == null ? "" : new File(module.getName()).getName(), "car");
        if (!environment.getConfigId().isResolved()) {
            throw new IllegalStateException("Service Module ID is not fully populated (" + environment.getConfigId() + ")");
        }
        return environment.getConfigId();
    }

    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile jar, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        ModuleType configType = (ModuleType)plan;
        return this.buildConfiguration(inPlaceDeployment, configId, configType, jar, configurationStores, artifactResolver, targetConfigurationStore);
    }

    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, ModuleType moduleType, JarFile jar, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws DeploymentException, IOException {
        File outfile;
        ArtifactType type = moduleType.getEnvironment().isSetModuleId() ? moduleType.getEnvironment().getModuleId() : moduleType.getEnvironment().addNewModuleId();
        type.setArtifactId(configId.getArtifactId());
        type.setGroupId(configId.getGroupId());
        type.setType(configId.getType());
        type.setVersion(configId.getVersion().toString());
        Environment environment = EnvironmentBuilder.buildEnvironment(moduleType.getEnvironment(), this.defaultEnvironment);
        if (!environment.getConfigId().isResolved()) {
            throw new IllegalStateException("Module ID should be fully resolved by now (not " + environment.getConfigId() + ")");
        }
        try {
            outfile = targetConfigurationStore.createNewConfigurationDir(configId);
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        DeploymentContext context = null;
        try {
            ConfigurationManager configurationManager = this.configurationManager;
            if (configurationManager == null) {
                configurationManager = new SimpleConfigurationManager(configurationStores, artifactResolver, this.repositories);
            }
            AbstractName moduleName = this.naming.createRootName(configId, configId.toString(), SERVICE_MODULE);
            context = new DeploymentContext(outfile, inPlaceDeployment && null != jar ? DeploymentUtil.toFile((JarFile)jar) : null, environment, moduleName, ConfigurationModuleType.SERVICE, this.naming, configurationManager, this.repositories);
            if (jar != null) {
                File file = new File(jar.getName());
                context.addIncludeAsPackedJar(URI.create(file.getName()), jar);
            }
            this.serviceBuilders.build((XmlObject)moduleType, context, context);
            return context;
        }
        catch (DeploymentException de) {
            this.cleanupAfterFailedBuild(context, outfile);
            throw de;
        }
        catch (IOException ie) {
            this.cleanupAfterFailedBuild(context, outfile);
            throw ie;
        }
        catch (RuntimeException re) {
            this.cleanupAfterFailedBuild(context, outfile);
            throw re;
        }
        catch (Error e) {
            this.cleanupAfterFailedBuild(context, outfile);
            throw e;
        }
    }

    private void cleanupAfterFailedBuild(DeploymentContext context, File directory) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (DeploymentException de) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (directory != null) {
            DeploymentUtil.recursiveDelete((File)directory);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        PropertyEditorManager.registerEditor(Environment.class, EnvironmentBuilder.class);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ServiceConfigBuilder.class, (String)"ConfigBuilder");
        infoBuilder.addInterface(ConfigurationBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true);
        infoBuilder.addReference("Repository", Repository.class, "Repository");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false, false);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "Repository", "ServiceBuilders", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

