/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.keystore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.KeyNotFoundException;
import org.apache.geronimo.management.geronimo.KeystoreException;
import org.apache.geronimo.management.geronimo.KeystoreInstance;
import org.apache.geronimo.management.geronimo.KeystoreIsLocked;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.asn1.ASN1InputStream;
import org.apache.geronimo.util.asn1.ASN1Sequence;
import org.apache.geronimo.util.asn1.ASN1Set;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.DEROutputStream;
import org.apache.geronimo.util.asn1.x509.X509CertificateStructure;
import org.apache.geronimo.util.asn1.x509.X509Name;
import org.apache.geronimo.util.encoders.Base64;
import org.apache.geronimo.util.jce.PKCS10CertificationRequest;
import org.apache.geronimo.util.jce.X509Principal;
import org.apache.geronimo.util.jce.X509V1CertificateGenerator;

public class FileKeystoreInstance
implements KeystoreInstance,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog(FileKeystoreInstance.class);
    static final String JKS = "JKS";
    private URI keystorePath;
    private ServerInfo serverInfo;
    private File keystoreFile;
    private String keystoreName;
    private char[] keystorePassword;
    private Map keyPasswords = new HashMap();
    private Kernel kernel;
    private AbstractName abstractName;
    private char[] openPassword;
    private List privateKeys = new ArrayList();
    private List trustCerts = new ArrayList();
    private KeyStore keystore;
    private long keystoreReadDate = Long.MIN_VALUE;
    public static final GBeanInfo GBEAN_INFO;

    public FileKeystoreInstance(ServerInfo serverInfo, URI keystorePath, String keystoreName, String keystorePassword, String keyPasswords, Kernel kernel, AbstractName abstractName) {
        this.serverInfo = serverInfo;
        this.keystorePath = keystorePath;
        this.keystoreName = keystoreName;
        this.kernel = kernel;
        this.abstractName = abstractName;
        char[] cArray = this.keystorePassword = keystorePassword == null ? null : keystorePassword.toCharArray();
        if (keyPasswords != null) {
            String[] keys = keyPasswords.split("\\]\\!\\[");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                int pos = key.indexOf(61);
                this.keyPasswords.put(key.substring(0, pos), key.substring(pos + 1).toCharArray());
            }
        }
    }

    public void doStart() throws Exception {
        this.keystoreFile = new File(this.serverInfo.resolveServer(this.keystorePath));
        if (!this.keystoreFile.exists() || !this.keystoreFile.canRead()) {
            throw new IllegalArgumentException("Invalid keystore file (" + this.keystorePath + " = " + this.keystoreFile.getAbsolutePath() + ")");
        }
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public void unlockKeystore(char[] password) throws KeystoreException {
        if (password == null) {
            throw new NullPointerException("password is null");
        }
        this.ensureLoaded(password);
        try {
            this.kernel.setAttribute(this.abstractName, "keystorePassword", (Object)new String(password));
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to set attribute keystorePassword on myself!", (Throwable)e);
        }
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password == null ? null : password.toCharArray();
    }

    public void lockKeystore(char[] password) throws KeystoreException {
        try {
            this.kernel.setAttribute(this.abstractName, "keystorePassword", null);
            this.keyPasswords.clear();
            this.storePasswords();
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to set attribute keystorePassword on myself!", (Throwable)e);
        }
    }

    public boolean isKeystoreLocked() {
        return this.keystorePassword == null;
    }

    public String[] listPrivateKeys(char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        return this.privateKeys.toArray(new String[this.privateKeys.size()]);
    }

    public void unlockPrivateKey(String alias, char[] storePassword, char[] password) throws KeystoreException {
        if (storePassword == null && this.keystorePassword == null) {
            throw new KeystoreException("storePassword is null and keystore is locked for availability.");
        }
        if (storePassword != null) {
            this.getPrivateKey(alias, storePassword, password);
        } else {
            this.getPrivateKey(alias, this.keystorePassword, password);
        }
        this.keyPasswords.put(alias, password);
        this.storePasswords();
    }

    public String[] getUnlockedKeys(char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        return this.keyPasswords.keySet().toArray(new String[this.keyPasswords.size()]);
    }

    public boolean isTrustStore(char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        return this.trustCerts.size() > 0;
    }

    public void lockPrivateKey(String alias, char[] storePassword) throws KeystoreException {
        if (storePassword == null) {
            throw new NullPointerException("storePassword is null");
        }
        this.ensureLoaded(storePassword);
        this.keyPasswords.remove(alias);
        this.storePasswords();
    }

    private void storePasswords() throws KeystoreException {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.keyPasswords.entrySet().iterator();
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append("]![");
            }
            Map.Entry entry = it.next();
            buf.append(entry.getKey()).append("=").append((char[])entry.getValue());
        }
        try {
            this.kernel.setAttribute(this.abstractName, "keyPasswords", (Object)(buf.length() == 0 ? null : buf.toString()));
        }
        catch (Exception e) {
            throw new KeystoreException("Unable to save key passwords in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
    }

    public void setKeyPasswords(String passwords) {
    }

    public boolean isKeyLocked(String alias) {
        return this.keyPasswords.get(alias) == null;
    }

    public String[] listTrustCertificates(char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        return this.trustCerts.toArray(new String[this.trustCerts.size()]);
    }

    public void importTrustCertificate(Certificate cert, String alias, char[] storePassword) throws KeystoreException {
        if (storePassword == null) {
            throw new NullPointerException("storePassword is null");
        }
        this.ensureLoaded(storePassword);
        try {
            this.keystore.setCertificateEntry(alias, cert);
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to set certificate entry in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        this.trustCerts.add(alias);
        this.saveKeystore(storePassword);
    }

    public void generateKeyPair(String alias, char[] storePassword, char[] keyPassword, String keyAlgorithm, int keySize, String signatureAlgorithm, int validity, String commonName, String orgUnit, String organization, String locality, String state, String country) throws KeystoreException {
        if (storePassword == null) {
            throw new NullPointerException("storePassword is null");
        }
        this.ensureLoaded(storePassword);
        try {
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance(keyAlgorithm);
            kpgen.initialize(keySize);
            KeyPair keyPair = kpgen.generateKeyPair();
            X509Certificate cert = this.generateCertificate(keyPair.getPublic(), keyPair.getPrivate(), signatureAlgorithm, validity, commonName, orgUnit, organization, locality, state, country);
            this.keystore.setKeyEntry(alias, keyPair.getPrivate(), keyPassword, new Certificate[]{cert});
            this.privateKeys.add(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to generate key pair in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new KeystoreException("Unable to generate key pair in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new KeystoreException("Unable to generate key pair in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to generate key pair in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        this.saveKeystore(storePassword);
    }

    public String generateCSR(String alias, char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            X509Certificate cert = (X509Certificate)this.keystore.getCertificate(alias);
            PrivateKey key = (PrivateKey)this.keystore.getKey(alias, (char[])this.keyPasswords.get(alias));
            String csr = this.generateCSR(cert, key);
            return csr;
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new KeystoreException("Unable to generate CSR in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
    }

    private String generateCSR(X509Certificate cert, PrivateKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        int len;
        X509Name subject;
        String sigalg = cert.getSigAlgName();
        try {
            ASN1InputStream ais = new ASN1InputStream(cert.getEncoded());
            X509CertificateStructure x509Struct = new X509CertificateStructure((ASN1Sequence)ais.readObject());
            ais.close();
            subject = x509Struct.getSubject();
        }
        catch (CertificateEncodingException e) {
            log.warn((Object)(e.toString() + " while retrieving subject from certificate to create CSR.  Using subjectDN instead."));
            subject = new X509Name(((Object)cert.getSubjectDN()).toString());
        }
        PublicKey publicKey = cert.getPublicKey();
        ASN1Set attributes = null;
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(sigalg, subject, publicKey, attributes, signingKey);
        if (!csr.verify()) {
            throw new KeyStoreException("CSR verification failed");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DEROutputStream deros = new DEROutputStream((OutputStream)os);
        deros.writeObject((Object)csr.getDERObject());
        String b64 = new String(Base64.encode((byte[])os.toByteArray()));
        String BEGIN_CERT_REQ = "-----BEGIN CERTIFICATE REQUEST-----";
        String END_CERT_REQ = "-----END CERTIFICATE REQUEST-----";
        int CERT_REQ_LINE_LENGTH = 70;
        StringBuffer sbuf = new StringBuffer("-----BEGIN CERTIFICATE REQUEST-----").append('\n');
        for (int idx = 0; idx < b64.length(); idx += len) {
            len = idx + 70 > b64.length() ? b64.length() - idx : 70;
            String chunk = b64.substring(idx, idx + len);
            sbuf.append(chunk).append('\n');
        }
        sbuf.append("-----END CERTIFICATE REQUEST-----");
        return sbuf.toString();
    }

    public void importPKCS7Certificate(String alias, String certbuf, char[] storePassword) throws KeystoreException {
        if (storePassword == null) {
            throw new NullPointerException("storePassword is null");
        }
        this.ensureLoaded(storePassword);
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(certbuf.getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certcoll = cf.generateCertificates(is);
            Certificate[] chain = new Certificate[certcoll.size()];
            Iterator<? extends Certificate> iter = certcoll.iterator();
            int i = 0;
            while (iter.hasNext()) {
                chain[i] = iter.next();
                ++i;
            }
            if (this.keystore.getCertificate(alias).getPublicKey().equals(chain[0].getPublicKey())) {
                char[] keyPassword = (char[])this.keyPasswords.get(alias);
                this.keystore.setKeyEntry(alias, this.keystore.getKey(alias, keyPassword), keyPassword, chain);
                this.saveKeystore(this.keystorePassword);
            } else {
                log.error((Object)("Error in importPKCS7Certificate.  PublicKey in the certificate received is not related to the PrivateKey in the keystore. keystore = " + this.keystoreName + ", alias = " + alias));
            }
        }
        catch (CertificateException e) {
            throw new KeystoreException("Unable to import PKCS7 certificat in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to import PKCS7 certificat in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to import PKCS7 certificat in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeystoreException("Unable to import PKCS7 certificat in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void deleteEntry(String alias, char[] storePassword) throws KeystoreException {
        if (storePassword == null) {
            throw new NullPointerException("storePassword is null");
        }
        this.ensureLoaded(storePassword);
        try {
            this.keystore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to delete key in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        this.privateKeys.remove(alias);
        this.trustCerts.remove(alias);
        if (this.keyPasswords.containsKey(alias)) {
            this.keyPasswords.remove(alias);
            this.storePasswords();
        }
        this.saveKeystore(storePassword);
    }

    public KeyManager[] getKeyManager(String algorithm, String alias, char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(algorithm);
            if (this.privateKeys.size() == 1) {
                keyFactory.init(this.keystore, (char[])this.keyPasswords.get(alias));
            } else {
                KeyStore subKeystore = KeyStore.getInstance(this.keystore.getType(), this.keystore.getProvider());
                try {
                    subKeystore.load(null, null);
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (CertificateException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                subKeystore.setKeyEntry(alias, this.keystore.getKey(alias, (char[])this.keyPasswords.get(alias)), (char[])this.keyPasswords.get(alias), this.keystore.getCertificateChain(alias));
                keyFactory.init(subKeystore, (char[])this.keyPasswords.get(alias));
            }
            return keyFactory.getKeyManagers();
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to retrieve key manager in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to retrieve key manager in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeystoreException("Unable to retrieve key manager in keystore '" + this.keystoreName + "' for alias '" + alias + "'", (Throwable)e);
        }
    }

    public TrustManager[] getTrustManager(String algorithm, char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(algorithm);
            trustFactory.init(this.keystore);
            return trustFactory.getTrustManagers();
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to retrieve trust manager in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to retrieve trust manager in keystore '" + this.keystoreName + "'", (Throwable)e);
        }
    }

    public PrivateKey getPrivateKey(String alias, char[] storePassword, char[] keyPassword) throws KeyNotFoundException, KeystoreException, KeystoreIsLocked {
        this.ensureLoaded(storePassword);
        try {
            PrivateKey key = (PrivateKey)this.keystore.getKey(alias, keyPassword);
            if (key == null) {
                throw new KeyNotFoundException("Keystore '" + this.keystoreName + "' does not contain a private key with alias'" + alias + "'.");
            }
            return key;
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to retrieve private key from keystore", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to retrieve private key from keystore", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeystoreException("Unable to retrieve private key from keystore", (Throwable)e);
        }
    }

    public Certificate getCertificate(String alias, char[] storePassword) throws KeystoreIsLocked, KeyNotFoundException, KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            Certificate cert = this.keystore.getCertificate(alias);
            if (cert == null) {
                throw new KeyNotFoundException("Keystore '" + this.keystoreName + "' does not contain a certificate with alias'" + alias + "'.");
            }
            return cert;
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to retrieve certificate from keystore", (Throwable)e);
        }
    }

    public String getCertificateAlias(Certificate cert, char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            String alias = this.keystore.getCertificateAlias(cert);
            if (alias == null) {
                throw new KeyNotFoundException("Keystore '" + this.keystoreName + "' does not contain an alias corresponding to the given certificate.");
            }
            return alias;
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to read certificate alias from keystore", (Throwable)e);
        }
    }

    public Certificate[] getCertificateChain(String alias, char[] storePassword) throws KeystoreException {
        this.ensureLoaded(storePassword);
        try {
            Certificate[] certs = this.keystore.getCertificateChain(alias);
            if (certs == null) {
                throw new KeyNotFoundException("Keystore '" + this.keystoreName + "' does not contain a certificate chain with alias'" + alias + "'.");
            }
            return certs;
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to read certificate chain from keystore", (Throwable)e);
        }
    }

    public Certificate getCertificate(String alias) {
        if (this.isKeystoreLocked()) {
            return null;
        }
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to read certificate from keystore", (Throwable)e);
            return null;
        }
    }

    private void loadKeystoreData(char[] password) throws KeystoreException {
        InputStream in = null;
        try {
            KeyStore tempKeystore = KeyStore.getInstance(JKS);
            in = new BufferedInputStream(new FileInputStream(this.keystoreFile));
            long readDate = System.currentTimeMillis();
            tempKeystore.load(in, password);
            this.keystore = tempKeystore;
            this.keystoreReadDate = readDate;
            this.privateKeys.clear();
            this.trustCerts.clear();
            this.openPassword = password;
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (this.keystore.isKeyEntry(alias)) {
                    this.privateKeys.add(alias);
                    continue;
                }
                if (!this.keystore.isCertificateEntry(alias)) continue;
                this.trustCerts.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to open keystore with provided password", (Throwable)e);
        }
        catch (IOException e) {
            throw new KeystoreException("Unable to open keystore with provided password", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to open keystore with provided password", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new KeystoreException("Unable to open keystore with provided password", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error while closing keystore file " + this.keystoreFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    private boolean isLoaded(char[] password) {
        if (this.openPassword == null || this.openPassword.length != password.length) {
            return false;
        }
        if (this.keystoreReadDate < this.keystoreFile.lastModified()) {
            return false;
        }
        for (int i = 0; i < password.length; ++i) {
            if (password[i] == this.openPassword[i]) continue;
            return false;
        }
        return true;
    }

    private void ensureLoaded(char[] storePassword) throws KeystoreException {
        char[] password;
        if (storePassword == null) {
            if (this.isKeystoreLocked()) {
                throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked; please unlock it in the console.");
            }
            password = this.keystorePassword;
        } else {
            password = storePassword;
        }
        if (!this.isLoaded(password)) {
            this.loadKeystoreData(password);
        }
    }

    private X509Certificate generateCertificate(PublicKey publicKey, PrivateKey privateKey, String algorithm, int validity, String commonName, String orgUnit, String organization, String locality, String state, String country) throws SignatureException, InvalidKeyException {
        X509V1CertificateGenerator certgen = new X509V1CertificateGenerator();
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, String> attrmap = new Hashtable<DERObjectIdentifier, String>();
        if (commonName != null) {
            attrmap.put(X509Principal.CN, commonName);
            order.add(X509Principal.CN);
        }
        if (orgUnit != null) {
            attrmap.put(X509Principal.OU, orgUnit);
            order.add(X509Principal.OU);
        }
        if (organization != null) {
            attrmap.put(X509Principal.O, organization);
            order.add(X509Principal.O);
        }
        if (locality != null) {
            attrmap.put(X509Principal.L, locality);
            order.add(X509Principal.L);
        }
        if (state != null) {
            attrmap.put(X509Principal.ST, state);
            order.add(X509Principal.ST);
        }
        if (country != null) {
            attrmap.put(X509Principal.C, country);
            order.add(X509Principal.C);
        }
        X509Principal issuerDN = new X509Principal(order, attrmap);
        long curr = System.currentTimeMillis();
        long untill = curr + (long)validity * 24L * 60L * 60L * 1000L;
        certgen.setNotBefore(new Date(curr));
        certgen.setNotAfter(new Date(untill));
        certgen.setIssuerDN((X509Name)issuerDN);
        certgen.setSubjectDN((X509Name)issuerDN);
        certgen.setPublicKey(publicKey);
        certgen.setSignatureAlgorithm(algorithm);
        certgen.setSerialNumber(new BigInteger(String.valueOf(curr)));
        return certgen.generateX509Certificate(privateKey);
    }

    private void saveKeystore(char[] password) throws KeystoreException {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.keystoreFile));
            this.keystore.store(out, password);
            out.flush();
            out.close();
            this.keystoreReadDate = System.currentTimeMillis();
        }
        catch (KeyStoreException e) {
            throw new KeystoreException("Unable to save keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new KeystoreException("Unable to save keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new KeystoreException("Unable to save keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeystoreException("Unable to save keystore '" + this.keystoreName + "'", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new KeystoreException("Unable to save keystore '" + this.keystoreName + "'", (Throwable)e);
        }
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(FileKeystoreInstance.class, (String)"Keystore");
        infoFactory.addAttribute("keystorePath", URI.class, true, false);
        infoFactory.addAttribute("keystoreName", String.class, true, false);
        infoFactory.addAttribute("keystorePassword", String.class, true, true);
        infoFactory.addAttribute("keyPasswords", String.class, true, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(KeystoreInstance.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "keystorePath", "keystoreName", "keystorePassword", "keyPasswords", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

