/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.Serializable;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;

public class UsernamePasswordCredential
implements Destroyable,
Refreshable,
Serializable {
    private String username;
    private char[] password;
    private boolean destroyed;

    public UsernamePasswordCredential(String username, char[] password) {
        assert (username != null);
        assert (password != null);
        this.username = username;
        this.password = new char[password.length];
        System.arraycopy(password, 0, this.password, 0, password.length);
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void destroy() throws DestroyFailedException {
        Arrays.fill(this.password, ' ');
        this.username = null;
        this.password = null;
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void refresh() throws RefreshFailedException {
    }

    public boolean isCurrent() {
        return !this.destroyed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsernamePasswordCredential)) {
            return false;
        }
        UsernamePasswordCredential credential = (UsernamePasswordCredential)o;
        if (this.destroyed != credential.destroyed) {
            return false;
        }
        if (!Arrays.equals(this.password, credential.password)) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(credential.username) : credential.username != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 29 * result + (this.destroyed ? 1 : 0);
        return result;
    }
}

