/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.PolicyConfigurationGeneric;

public class GeronimoPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private final Log log = LogFactory.getLog((Class)GeronimoPolicyConfigurationFactory.class);
    private static GeronimoPolicyConfigurationFactory singleton;
    private Map configurations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeronimoPolicyConfigurationFactory() {
        Class clazz = GeronimoPolicyConfigurationFactory.class;
        synchronized (clazz) {
            if (singleton != null) {
                this.log.error((Object)"Singleton already assigned.  There may be more than one GeronimoPolicyConfigurationFactory being used.");
                throw new IllegalStateException("Singleton already assigned");
            }
            singleton = this;
        }
    }

    public void setPolicyConfiguration(String contextID, GeronimoPolicyConfiguration configuration) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new GeronimoSecurityPermission("setPolicyConfiguration"));
        }
        this.configurations.put(contextID, configuration);
        this.log.trace((Object)("Set policy configuration " + contextID));
    }

    public GeronimoPolicyConfiguration getGeronimoPolicyConfiguration(String contextID) throws PolicyContextException {
        GeronimoPolicyConfiguration configuration = (GeronimoPolicyConfiguration)this.configurations.get(contextID);
        if (configuration == null) {
            throw new PolicyContextException("No policy configuration registered for contextID: " + contextID);
        }
        this.log.trace((Object)("Get policy configuration " + contextID));
        return configuration;
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        GeronimoPolicyConfiguration configuration = (GeronimoPolicyConfiguration)this.configurations.get(contextID);
        if (configuration == null) {
            configuration = new PolicyConfigurationGeneric(contextID);
            this.configurations.put(contextID, configuration);
        } else {
            configuration.open(remove);
        }
        this.log.trace((Object)("Get " + (remove ? "CLEANED" : "") + " policy configuration " + contextID));
        return configuration;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfiguration configuration = this.getPolicyConfiguration(contextID, false);
        this.log.trace((Object)("Policy configuration " + contextID + " put into service"));
        return configuration.inService();
    }

    static GeronimoPolicyConfigurationFactory getSingleton() {
        return singleton;
    }
}

