/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;
import org.apache.geronimo.security.deploy.LoginDomainPrincipalInfo;

public class RealmPrincipalInfo
extends LoginDomainPrincipalInfo {
    private final String realm;

    public RealmPrincipalInfo(String realm, String domainName, String className, String principalName, boolean designatedRunAs) {
        super(domainName, className, principalName, designatedRunAs);
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    static {
        PropertyEditorManager.registerEditor(RealmPrincipalInfo.class, RealmPrincipalEditor.class);
    }

    public static class RealmPrincipalEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                String[] parts = text.split(",");
                if (parts.length != 5) {
                    throw new PropertyEditorException("Principal should have the form 'realm,domain,class,name,run-as'");
                }
                RealmPrincipalInfo principal = new RealmPrincipalInfo(parts[0], parts[1], parts[2], parts[3], Boolean.valueOf(parts[4]));
                this.setValue(principal);
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            RealmPrincipalInfo principal = (RealmPrincipalInfo)this.getValue();
            if (principal == null) {
                return null;
            }
            return principal.getRealm() + "," + principal.getDomain() + "," + principal.getClassName() + "," + principal.getPrincipalName() + "," + principal.isDesignatedRunAs();
        }
    }
}

