/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.ca;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.CertificateRequestStore;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class FileCertificateRequestStore
implements CertificateRequestStore,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)FileCertificateRequestStore.class);
    private static final String CSR_STATUS_FILENAME = "csr-status.properties";
    private static final String CSR_STATUS_FILE_HEADER = "CSR Status File";
    private static final String STATUS_RECEIVED = "R";
    private static final String STATUS_VERIFIED = "V";
    private static final String CERT_REQ_FILE_PREFIX = "csr";
    private static final String CERT_REQ_FILE_SUFFIX = ".txt";
    private ServerInfo serverInfo;
    private Kernel kernel;
    private AbstractName abstractName;
    private URI directoryPath;
    private File dir;
    private Properties requestStatus;
    public static final GBeanInfo GBEAN_INFO;

    public FileCertificateRequestStore(ServerInfo serverInfo, URI directoryPath, Kernel kernel, AbstractName abstractName) {
        this.serverInfo = serverInfo;
        this.kernel = kernel;
        this.abstractName = abstractName;
        this.directoryPath = directoryPath;
    }

    public boolean deleteRequest(String id) {
        if (this.requestStatus.containsKey(id)) {
            this.requestStatus.remove(id);
            this.storeRequestStatusFile();
        }
        return new File(this.dir, id + CERT_REQ_FILE_SUFFIX).delete();
    }

    public String[] getAllRequestIds() {
        File[] results = this.dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(FileCertificateRequestStore.CERT_REQ_FILE_SUFFIX);
            }
        });
        String[] reqIds = new String[results.length];
        int suffixLength = CERT_REQ_FILE_SUFFIX.length();
        for (int i = 0; i < results.length; ++i) {
            String name = results[i].getName();
            reqIds[i] = name.substring(0, name.length() - suffixLength);
        }
        return reqIds;
    }

    public String[] getVerificatonDueRequestIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        Iterator<Map.Entry<Object, Object>> itr = this.requestStatus.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!entry.getValue().equals(STATUS_RECEIVED)) continue;
            ids.add(entry.getKey());
        }
        return ids.toArray(new String[0]);
    }

    public String[] getVerifiedRequestIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        Iterator<Map.Entry<Object, Object>> itr = this.requestStatus.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!entry.getValue().equals(STATUS_VERIFIED)) continue;
            ids.add(entry.getKey());
        }
        return ids.toArray(new String[0]);
    }

    public boolean setRequestVerified(String id) {
        if (this.requestStatus.containsKey(id)) {
            this.requestStatus.setProperty(id, STATUS_VERIFIED);
            this.storeRequestStatusFile();
            return true;
        }
        return false;
    }

    public boolean setRequestFulfilled(String id, BigInteger sNo) {
        if (this.requestStatus.containsKey(id)) {
            this.deleteRequest(id);
            this.requestStatus.setProperty(id, sNo.toString());
            this.storeRequestStatusFile();
            return true;
        }
        return false;
    }

    public String getRequest(String id) {
        try {
            FileInputStream fin = new FileInputStream(new File(this.dir, id + CERT_REQ_FILE_SUFFIX));
            byte[] data = new byte[fin.available()];
            fin.read(data);
            fin.close();
            return new String(data);
        }
        catch (Exception e) {
            log.error((Object)("Error reading CSR. id = " + id), (Throwable)e);
            return null;
        }
    }

    public String storeRequest(String id, String csr) {
        try {
            File csrFile = null;
            if (id == null || new File(this.dir, id + CERT_REQ_FILE_SUFFIX).exists()) {
                csrFile = File.createTempFile(CERT_REQ_FILE_PREFIX, CERT_REQ_FILE_SUFFIX, this.dir);
                id = csrFile.getName().substring(0, csrFile.getName().length() - CERT_REQ_FILE_SUFFIX.length());
            } else {
                csrFile = new File(this.dir, id + CERT_REQ_FILE_SUFFIX);
            }
            FileOutputStream fout = new FileOutputStream(csrFile);
            fout.write(csr.getBytes());
            this.requestStatus.setProperty(id, STATUS_RECEIVED);
            this.storeRequestStatusFile();
            fout.close();
            return id;
        }
        catch (Exception e) {
            log.error((Object)("Error storing CSR. id = " + id), (Throwable)e);
            return null;
        }
    }

    public BigInteger getSerialNumberForRequest(String id) {
        BigInteger sNo = null;
        try {
            sNo = new BigInteger(this.requestStatus.getProperty(id));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sNo;
    }

    public void removeRequestStatus(String id, BigInteger sNo) {
        if (id != null && this.requestStatus.containsKey(id)) {
            this.requestStatus.remove(id);
            this.storeRequestStatusFile();
        } else if (sNo != null && this.requestStatus.containsValue(sNo.toString())) {
            String sNoTemp = sNo.toString();
            Iterator<Map.Entry<Object, Object>> itr = this.requestStatus.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Object, Object> entry = itr.next();
                if (!sNoTemp.equals(entry.getValue())) continue;
                this.requestStatus.remove(entry.getKey());
                break;
            }
            this.storeRequestStatusFile();
        }
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        this.serverInfo.resolveServer(this.directoryPath);
        URI dirURI = this.serverInfo != null ? this.serverInfo.resolve(this.directoryPath) : this.directoryPath;
        if (!dirURI.getScheme().equals("file")) {
            throw new IllegalStateException("FileCertificateRequestStore must have a root that's a local directory (not " + dirURI + ")");
        }
        this.dir = new File(dirURI);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
            log.debug((Object)("Created directory " + this.dir.getAbsolutePath()));
        } else if (!this.dir.isDirectory() || !this.dir.canRead()) {
            throw new IllegalStateException("FileCertificateRequestStore must have a root that's a valid readable directory (not " + this.dir.getAbsolutePath() + ")");
        }
        log.debug((Object)("CertificateRequestStore directory is " + this.dir.getAbsolutePath()));
        File statusFile = new File(this.dir, CSR_STATUS_FILENAME);
        if (!statusFile.exists()) {
            statusFile.createNewFile();
            log.debug((Object)("Created request status file " + statusFile.getAbsolutePath()));
        }
        this.requestStatus = new Properties();
        FileInputStream fin = new FileInputStream(statusFile);
        this.requestStatus.load(fin);
        fin.close();
    }

    public void doStop() throws Exception {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    private void storeRequestStatusFile() {
        File statusFile = new File(this.dir, CSR_STATUS_FILENAME);
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(statusFile);
            this.requestStatus.store(fout, CSR_STATUS_FILE_HEADER);
            fout.close();
        }
        catch (Exception e) {
            log.error((Object)("Errors while storing request status file " + statusFile.getAbsolutePath()), (Throwable)e);
        }
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)FileCertificateRequestStore.class, (String)"CertificateRequestStore");
        infoFactory.addAttribute("directoryPath", URI.class, true, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(CertificateRequestStore.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "directoryPath", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

