/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geronimo.farm.discovery.MulticastLocation;
import org.apache.geronimo.farm.discovery.MulticastSearch;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;

@GBean
public class HeartbeatMonitor
implements org.apache.geronimo.system.plugin.HeartbeatMonitor {
    private final MulticastLocation location;

    public HeartbeatMonitor(@ParamReference(name="MulticastLocation") MulticastLocation location) {
        this.location = location;
    }

    public void monitor(final InputStream in, OutputStream output, String pattern) {
        Pattern regex;
        if (pattern == null || pattern.equals("")) {
            pattern = ".*";
        }
        final PrintStream out = new PrintStream(output);
        try {
            regex = Pattern.compile(pattern);
        }
        catch (Exception e) {
            out.println("Invalid java.util.regex.Pattern \"" + pattern + "\"");
            return;
        }
        out.println("Hit any key to stop.");
        final AtomicBoolean stop = new AtomicBoolean();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    in.read();
                }
                catch (IOException iOException) {
                }
                finally {
                    stop.set(true);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
        try {
            MulticastSearch multicast = new MulticastSearch(this.location.getHost(), this.location.getPort());
            multicast.search(new MulticastSearch.Filter(){

                public boolean accept(URI service) {
                    String s = service.toString();
                    Matcher matcher = regex.matcher(s);
                    if (matcher.matches()) {
                        out.println(s);
                    }
                    return stop.get();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace(out);
        }
    }
}

