/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.persistence20.PersistenceDocument;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;

public class PersistenceUnitBuilder
implements ModuleBuilderExtension {
    private static final EARContext.Key<List<URL>> PERSISTENCE_URL_LIST_KEY = new EARContext.Key<List<URL>>(){

        public List<URL> get(Map<EARContext.Key, Object> keyObjectMap) {
            ArrayList list = (ArrayList)keyObjectMap.get(this);
            if (list == null) {
                list = new ArrayList();
                keyObjectMap.put(this, list);
            }
            return list;
        }
    };
    private static final QName PERSISTENCE_QNAME = PersistenceDocument.type.getDocumentElementName();
    private final Environment defaultEnvironment;
    private final String defaultPersistenceProviderClassName;
    private final Properties defaultPersistenceUnitProperties;
    private final AbstractNameQuery defaultJtaDataSourceName;
    private final AbstractNameQuery defaultNonJtaDataSourceName;
    private final AbstractNameQuery extendedEntityManagerRegistryName;
    private static final String ANON_PU_NAME = "AnonymousPersistenceUnit";
    private static final String RESOURCE_SOURCE_CLASS_NAME = ResourceSource.class.getName();
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceUnitBuilder(Environment defaultEnvironment, String defaultPersistenceProviderClassName, String defaultJtaDataSourceName, String defaultNonJtaDataSourceName, AbstractNameQuery extendedEntityManagerRegistryName, Properties defaultPersistenceUnitProperties) throws URISyntaxException {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultPersistenceProviderClassName = defaultPersistenceProviderClassName;
        this.defaultJtaDataSourceName = defaultJtaDataSourceName == null ? null : this.getAbstractNameQuery(defaultJtaDataSourceName);
        this.defaultNonJtaDataSourceName = defaultNonJtaDataSourceName == null ? null : this.getAbstractNameQuery(defaultNonJtaDataSourceName);
        this.extendedEntityManagerRegistryName = extendedEntityManagerRegistryName;
        this.defaultPersistenceUnitProperties = defaultPersistenceUnitProperties == null ? new Properties() : defaultPersistenceUnitProperties;
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        if (module.getDeployable() instanceof DeployableBundle) {
            return;
        }
        XmlObject container = (XmlObject)module.getVendorDD();
        EARContext moduleContext = module.getEarContext();
        XmlObject[] raws = container.selectChildren(PERSISTENCE_QNAME);
        HashMap<String, PersistenceDocument.Persistence.PersistenceUnit> overrides = new HashMap<String, PersistenceDocument.Persistence.PersistenceUnit>();
        try {
            for (XmlObject raw : raws) {
                PersistenceDocument.Persistence persistence = this.convertToPersistenceUnit(raw.copy());
                for (PersistenceDocument.Persistence.PersistenceUnit unit : persistence.getPersistenceUnitArray()) {
                    overrides.put(unit.getName().trim(), unit);
                }
            }
        }
        catch (XmlException e) {
            throw new DeploymentException("Parse Persistence configuration file failed", (Throwable)e);
        }
        try {
            File rootBaseFile = module.getRootEarContext().getConfiguration().getConfigurationDir();
            String rootBase = rootBaseFile.toURI().normalize().toString();
            URI moduleBaseURI = moduleContext.getBaseDir().toURI();
            Map rootGeneralData = module.getRootEarContext().getGeneralData();
            ClassPathList manifestcp = (ClassPathList)EARContext.CLASS_PATH_LIST_KEY.get(module.getEarContext().getGeneralData());
            if (manifestcp == null) {
                manifestcp = new ClassPathList();
                manifestcp.add((Object)module.getTargetPath());
            }
            URL[] urls = new URL[manifestcp.size()];
            int i = 0;
            for (String path : manifestcp) {
                path = path.replaceAll(" ", "%20");
                URL url = moduleBaseURI.resolve(path).toURL();
                urls[i++] = url;
            }
            ResourceFinder finder = new ResourceFinder("", null, urls);
            List knownPersistenceUrls = (List)PERSISTENCE_URL_LIST_KEY.get(rootGeneralData);
            List persistenceUrls = finder.findAll("META-INF/persistence.xml");
            persistenceUrls.removeAll(knownPersistenceUrls);
            if (raws.length > 0 || persistenceUrls.size() > 0) {
                EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
            }
            for (URL persistenceUrl : persistenceUrls) {
                String persistenceLocation;
                try {
                    persistenceLocation = persistenceUrl.toURI().toString();
                }
                catch (URISyntaxException e) {
                    continue;
                }
                int pos = persistenceLocation.indexOf(rootBase);
                if (pos < 0) continue;
                int endPos = persistenceLocation.lastIndexOf("!/");
                if (endPos < 0) {
                    endPos = persistenceLocation.lastIndexOf("META-INF");
                }
                if (endPos >= 0) {
                    PersistenceDocument persistenceDocument;
                    String relative = persistenceLocation.substring(pos + rootBase.length(), endPos);
                    relative = module.getRelativePath(relative);
                    try {
                        XmlObject xmlObject = XmlBeansUtil.parse((URL)persistenceUrl, (ClassLoader)new BundleClassLoader(moduleContext.getDeploymentBundle()));
                        persistenceDocument = this.convertToPersistenceDocument(xmlObject);
                    }
                    catch (XmlException e) {
                        throw new DeploymentException("Could not parse persistence.xml file: " + persistenceUrl, (Throwable)e);
                    }
                    PersistenceDocument.Persistence persistence = persistenceDocument.getPersistence();
                    this.buildPersistenceUnits(persistence, overrides, module, relative);
                    knownPersistenceUrls.add(persistenceUrl);
                    continue;
                }
                throw new DeploymentException("Could not find persistence.xml file: " + persistenceUrl);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not look for META-INF/persistence.xml files", (Throwable)e);
        }
        for (PersistenceDocument.Persistence.PersistenceUnit persistenceUnit : overrides.values()) {
            GBeanData data = this.installPersistenceUnitGBean(persistenceUnit, module, module.getTargetPath());
            this.respectExcludeUnlistedClasses(data);
        }
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistenceDocument convertToPersistenceDocument(XmlObject xmlObject) throws XmlException {
        XmlCursor cursor = null;
        try {
            cursor = xmlObject.newCursor();
            cursor.toStartDoc();
            cursor.toFirstChild();
            SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/persistence", (String)"http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd", (String)"2.0");
            XmlObject result = xmlObject.changeType(PersistenceDocument.type);
            XmlBeansUtil.validateDD((XmlObject)result);
            PersistenceDocument persistenceDocument = (PersistenceDocument)result;
            return persistenceDocument;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.dispose();
                }
                catch (Exception e) {}
            }
        }
    }

    protected PersistenceDocument.Persistence convertToPersistenceUnit(XmlObject xmlObject) throws XmlException {
        XmlObject result = xmlObject.changeType(PersistenceDocument.Persistence.type);
        XmlBeansUtil.validateDD((XmlObject)result);
        return (PersistenceDocument.Persistence)result;
    }

    private void buildPersistenceUnits(PersistenceDocument.Persistence persistence, Map<String, PersistenceDocument.Persistence.PersistenceUnit> overrides, Module module, String persistenceModulePath) throws DeploymentException {
        PersistenceDocument.Persistence.PersistenceUnit[] persistenceUnits;
        for (PersistenceDocument.Persistence.PersistenceUnit persistenceUnit : persistenceUnits = persistence.getPersistenceUnitArray()) {
            GBeanData data = this.installPersistenceUnitGBean(persistenceUnit, module, persistenceModulePath);
            String unitName = persistenceUnit.getName().trim();
            if (overrides.get(unitName) != null) {
                this.setOverrideableProperties(overrides.remove(unitName), data);
            }
            this.respectExcludeUnlistedClasses(data);
        }
    }

    private GBeanData installPersistenceUnitGBean(PersistenceDocument.Persistence.PersistenceUnit persistenceUnit, Module module, String persistenceModulePath) throws DeploymentException {
        AbstractName abstractName;
        EARContext moduleContext = module.getEarContext();
        String persistenceUnitName = persistenceUnit.getName().trim();
        if (persistenceUnitName.length() == 0) {
            persistenceUnitName = ANON_PU_NAME;
        }
        if (persistenceModulePath == null || persistenceModulePath.length() == 0) {
            abstractName = moduleContext.getNaming().createChildName(module.getModuleName(), persistenceUnitName, "PersistenceUnit");
        } else {
            abstractName = moduleContext.getNaming().createChildName(module.getModuleName(), persistenceModulePath, "PersistenceUnitModule");
            abstractName = moduleContext.getNaming().createChildName(abstractName, moduleContext.getConfigID(), persistenceUnitName, "PersistenceUnit");
        }
        GBeanData gbeanData = new GBeanData(abstractName, PersistenceUnitGBean.class);
        try {
            moduleContext.addGBean(gbeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Duplicate persistenceUnit name " + persistenceUnitName, (Throwable)e);
        }
        gbeanData.setAttribute("persistenceUnitName", (Object)persistenceUnitName);
        gbeanData.setAttribute("persistenceUnitRoot", (Object)persistenceModulePath);
        gbeanData.setAttribute("persistenceProviderClassName", (Object)this.defaultPersistenceProviderClassName);
        gbeanData.setAttribute("persistenceUnitTransactionType", (Object)"JTA");
        if (this.defaultJtaDataSourceName != null) {
            gbeanData.setReferencePattern("JtaDataSourceWrapper", this.defaultJtaDataSourceName);
        }
        if (this.defaultNonJtaDataSourceName != null) {
            gbeanData.setReferencePattern("NonJtaDataSourceWrapper", this.defaultNonJtaDataSourceName);
        }
        gbeanData.setAttribute("mappingFileNames", new ArrayList());
        gbeanData.setAttribute("excludeUnlistedClasses", (Object)false);
        gbeanData.setAttribute("managedClassNames", new ArrayList());
        gbeanData.setAttribute("jarFileUrls", new ArrayList());
        Properties properties = new Properties();
        gbeanData.setAttribute("properties", (Object)properties);
        properties.putAll((Map<?, ?>)this.defaultPersistenceUnitProperties);
        AbstractNameQuery transactionManagerName = moduleContext.getTransactionManagerName();
        gbeanData.setReferencePattern("TransactionManager", transactionManagerName);
        gbeanData.setReferencePattern("EntityManagerRegistry", this.extendedEntityManagerRegistryName);
        this.setOverrideableProperties(persistenceUnit, gbeanData);
        return gbeanData;
    }

    private void setOverrideableProperties(PersistenceDocument.Persistence.PersistenceUnit persistenceUnit, GBeanData gbeanData) throws DeploymentException {
        String[] jarFileUrlStrings;
        String[] mappingFileNameStrings;
        if (persistenceUnit.isSetProvider()) {
            gbeanData.setAttribute("persistenceProviderClassName", (Object)persistenceUnit.getProvider().trim());
        }
        if (persistenceUnit.isSetTransactionType()) {
            gbeanData.setAttribute("persistenceUnitTransactionType", (Object)persistenceUnit.getTransactionType().toString());
        }
        if (persistenceUnit.isSetJtaDataSource()) {
            String jtaDataSourceString = persistenceUnit.getJtaDataSource().trim();
            try {
                AbstractNameQuery jtaDataSourceNameQuery = this.getAbstractNameQuery(jtaDataSourceString);
                gbeanData.setReferencePattern("JtaDataSourceWrapper", jtaDataSourceNameQuery);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not create jta-data-source AbstractNameQuery from string: " + jtaDataSourceString, (Throwable)e);
            }
        }
        if (persistenceUnit.isSetNonJtaDataSource()) {
            String nonJtaDataSourceString = persistenceUnit.getNonJtaDataSource().trim();
            try {
                AbstractNameQuery nonJtaDataSourceNameQuery = this.getAbstractNameQuery(nonJtaDataSourceString);
                gbeanData.setReferencePattern("NonJtaDataSourceWrapper", nonJtaDataSourceNameQuery);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not create non-jta-data-source AbstractNameQuery from string: " + nonJtaDataSourceString, (Throwable)e);
            }
        }
        List mappingFileNames = (List)gbeanData.getAttribute("mappingFileNames");
        for (String mappingFileNameString : mappingFileNameStrings = persistenceUnit.getMappingFileArray()) {
            mappingFileNames.add(mappingFileNameString.trim());
        }
        if (persistenceUnit.isSetExcludeUnlistedClasses()) {
            gbeanData.setAttribute("excludeUnlistedClasses", (Object)persistenceUnit.getExcludeUnlistedClasses());
        }
        String[] managedClassNameStrings = persistenceUnit.getClass1Array();
        List managedClassNames = (List)gbeanData.getAttribute("managedClassNames");
        for (String managedClassNameString : managedClassNameStrings) {
            managedClassNames.add(managedClassNameString.trim());
        }
        List jarFileUrls = (List)gbeanData.getAttribute("jarFileUrls");
        for (String jarFileUrlString : jarFileUrlStrings = persistenceUnit.getJarFileArray()) {
            jarFileUrls.add(jarFileUrlString.trim());
        }
        if (persistenceUnit.isSetProperties()) {
            PersistenceDocument.Persistence.PersistenceUnit.Properties.Property[] propertyObjects;
            Properties properties = (Properties)gbeanData.getAttribute("properties");
            for (PersistenceDocument.Persistence.PersistenceUnit.Properties.Property propertyObject : propertyObjects = persistenceUnit.getProperties().getPropertyArray()) {
                String key = propertyObject.getName().trim();
                String value = propertyObject.getValue().trim();
                properties.setProperty(key, value);
            }
        }
    }

    private void respectExcludeUnlistedClasses(GBeanData gbeanData) {
        boolean excludeUnlistedClasses = (Boolean)gbeanData.getAttribute("excludeUnlistedClasses");
        if (excludeUnlistedClasses) {
            gbeanData.clearAttribute("jarFileUrls");
        }
    }

    private AbstractNameQuery getAbstractNameQuery(String dataSourceString) throws URISyntaxException {
        if (dataSourceString.indexOf(61) == -1) {
            dataSourceString = "?name=" + dataSourceString;
        }
        AbstractNameQuery dataSourceNameQuery = new AbstractNameQuery(new URI(dataSourceString + "#" + RESOURCE_SOURCE_CLASS_NAME));
        return dataSourceNameQuery;
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.singleton((QName)PERSISTENCE_QNAME);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceUnitBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultPersistenceProviderClassName", String.class, true, true);
        infoBuilder.addAttribute("defaultJtaDataSourceName", String.class, true, true);
        infoBuilder.addAttribute("defaultNonJtaDataSourceName", String.class, true, true);
        infoBuilder.addAttribute("extendedEntityManagerRegistryName", AbstractNameQuery.class, true, true);
        infoBuilder.addAttribute("defaultPersistenceUnitProperties", Properties.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultPersistenceProviderClassName", "defaultJtaDataSourceName", "defaultNonJtaDataSourceName", "extendedEntityManagerRegistryName", "defaultPersistenceUnitProperties"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

