/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.kernel.classloader.TemporaryClassLoader;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.persistence.CMPEntityManagerExtended;
import org.apache.geronimo.persistence.CMPEntityManagerTxScoped;
import org.apache.geronimo.persistence.ExtendedEntityManagerRegistry;
import org.apache.geronimo.persistence.TransformerWrapper;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transformer.TransformerAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitGBean
implements GBeanLifecycle {
    private static final List<URL> NO_URLS = Collections.emptyList();
    private static final List<String> NO_STRINGS = Collections.emptyList();
    private final String persistenceUnitRoot;
    private final PersistenceUnitInfoImpl persistenceUnitInfo;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionManagerImpl transactionManager;
    private final SingleElementCollection<ExtendedEntityManagerRegistry> entityManagerRegistry;
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceUnitGBean() {
        this.persistenceUnitRoot = null;
        this.persistenceUnitInfo = null;
        this.entityManagerFactory = null;
        this.transactionManager = null;
        this.entityManagerRegistry = null;
    }

    public PersistenceUnitGBean(String persistenceUnitName, String persistenceProviderClassName, String persistenceUnitTransactionTypeString, ResourceSource<ResourceException> jtaDataSourceWrapper, ResourceSource<ResourceException> nonJtaDataSourceWrapper, List<String> mappingFileNamesUntyped, List<String> jarFileUrlsUntyped, String persistenceUnitRoot, List<String> managedClassNames, boolean excludeUnlistedClassesValue, Properties properties, TransactionManagerImpl transactionManager, Collection<ExtendedEntityManagerRegistry> entityManagerRegistry, URL configurationBaseURL, ClassLoader classLoader) throws URISyntaxException, MalformedURLException, ResourceException {
        PersistenceUnitTransactionType persistenceUnitTransactionType;
        ArrayList<String> mappingFileNames = mappingFileNamesUntyped == null ? NO_STRINGS : new ArrayList<String>(mappingFileNamesUntyped);
        this.persistenceUnitRoot = persistenceUnitRoot;
        URI configurationBaseURI = new File(configurationBaseURL.getFile()).toURI();
        URL rootURL = configurationBaseURI.resolve(persistenceUnitRoot).normalize().toURL();
        List<URL> jarFileUrls = NO_URLS;
        if (!excludeUnlistedClassesValue) {
            jarFileUrls = new ArrayList<URL>();
            URI persistenceUnitBaseURI = configurationBaseURI.resolve(persistenceUnitRoot);
            for (String urlString : jarFileUrlsUntyped) {
                URL url = persistenceUnitBaseURI.resolve(urlString).normalize().toURL();
                jarFileUrls.add(url);
            }
        }
        if (managedClassNames == null) {
            managedClassNames = NO_STRINGS;
        }
        if (properties == null) {
            properties = new Properties();
        }
        PersistenceUnitTransactionType persistenceUnitTransactionType2 = persistenceUnitTransactionType = persistenceUnitTransactionTypeString == null ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.valueOf((String)persistenceUnitTransactionTypeString);
        if (persistenceProviderClassName == null) {
            persistenceProviderClassName = "org.apache.openjpa.persistence.PersistenceProviderImpl";
        }
        this.persistenceUnitInfo = new PersistenceUnitInfoImpl(persistenceUnitName, persistenceProviderClassName, persistenceUnitTransactionType, jtaDataSourceWrapper == null ? null : (DataSource)jtaDataSourceWrapper.$getResource(), nonJtaDataSourceWrapper == null ? null : (DataSource)nonJtaDataSourceWrapper.$getResource(), mappingFileNames, jarFileUrls, rootURL, managedClassNames, excludeUnlistedClassesValue, properties, classLoader);
        try {
            Class<?> clazz = classLoader.loadClass(persistenceProviderClassName);
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            this.entityManagerFactory = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, (Map)properties);
        }
        catch (ClassNotFoundException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not locate PersistenceProvider class: " + persistenceProviderClassName + " in classloader " + classLoader, (Throwable)e);
        }
        catch (InstantiationException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        this.transactionManager = transactionManager;
        this.entityManagerRegistry = new SingleElementCollection(entityManagerRegistry);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManager getEntityManager(boolean transactionScoped, Map properties) {
        if (transactionScoped) {
            return new CMPEntityManagerTxScoped(this.transactionManager, this.getPersistenceUnitName(), this.entityManagerFactory, properties);
        }
        if (this.entityManagerRegistry.getElement() != null) {
            return new CMPEntityManagerExtended((ExtendedEntityManagerRegistry)this.entityManagerRegistry.getElement(), this.entityManagerFactory, properties);
        }
        throw new NullPointerException("No ExtendedEntityManagerRegistry supplied, you cannot use extended persistence contexts");
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }

    public String getPersistenceUnitRoot() {
        return this.persistenceUnitRoot;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceUnitInfo.getPersistenceProviderClassName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitInfo.getTransactionType();
    }

    public DataSource getJtaDataSource() {
        return this.persistenceUnitInfo.getJtaDataSource();
    }

    public DataSource getNonJtaDataSource() {
        return this.persistenceUnitInfo.getNonJtaDataSource();
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnitInfo.getMappingFileNames();
    }

    public List<URL> getJarFileUrls() {
        return this.persistenceUnitInfo.getJarFileUrls();
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitInfo.getPersistenceUnitRootUrl();
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnitInfo.getManagedClassNames();
    }

    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.persistenceUnitInfo.getProperties();
    }

    public ClassLoader getClassLoader() {
        return this.persistenceUnitInfo.getClassLoader();
    }

    public void addTransformer(ClassTransformer classTransformer) {
        this.persistenceUnitInfo.addTransformer(classTransformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.persistenceUnitInfo.getNewTempClassLoader();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.entityManagerFactory.close();
        this.persistenceUnitInfo.destroy();
    }

    public void doFail() {
        this.entityManagerFactory.close();
        this.persistenceUnitInfo.destroy();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceUnitGBean.class, (String)"PersistenceUnit");
        infoBuilder.setPriority(1);
        infoBuilder.addAttribute("persistenceUnitName", String.class, true, true);
        infoBuilder.addAttribute("persistenceProviderClassName", String.class, true, true);
        infoBuilder.addAttribute("persistenceUnitTransactionType", String.class, true, true);
        infoBuilder.addAttribute("mappingFileNames", List.class, true, true);
        infoBuilder.addAttribute("jarFileUrls", List.class, true, true);
        infoBuilder.addAttribute("persistenceUnitRoot", String.class, true, true);
        infoBuilder.addAttribute("managedClassNames", List.class, true, true);
        infoBuilder.addAttribute("excludeUnlistedClasses", Boolean.TYPE, true, true);
        infoBuilder.addAttribute("properties", Properties.class, true, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addReference("TransactionManager", TransactionManagerImpl.class, "JTAResource");
        infoBuilder.addReference("JtaDataSourceWrapper", ResourceSource.class, "JCAManagedConnectionFactory");
        infoBuilder.addReference("NonJtaDataSourceWrapper", ResourceSource.class, "JCAManagedConnectionFactory");
        infoBuilder.addReference("EntityManagerRegistry", ExtendedEntityManagerRegistry.class, "GBean");
        infoBuilder.setConstructor(new String[]{"persistenceUnitName", "persistenceProviderClassName", "persistenceUnitTransactionType", "JtaDataSourceWrapper", "NonJtaDataSourceWrapper", "mappingFileNames", "jarFileUrls", "persistenceUnitRoot", "managedClassNames", "excludeUnlistedClasses", "properties", "TransactionManager", "EntityManagerRegistry", "configurationBaseUrl", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;
        private final String persistenceProviderClassName;
        private final PersistenceUnitTransactionType persistenceUnitTransactionType;
        private final DataSource jtaDataSource;
        private final DataSource nonJtaDataSource;
        private final List<String> mappingFileNames;
        private final List<URL> jarFileUrls;
        private final URL persistenceUnitRootUrl;
        private final List<String> managedClassNames;
        private final boolean excludeUnlistedClassesValue;
        private final Properties properties;
        private final ClassLoader classLoader;
        private final TemporaryClassLoader tempClassLoader;
        private final List<TransformerWrapper> transformers;

        public PersistenceUnitInfoImpl(String persistenceUnitName, String persistenceProviderClassName, PersistenceUnitTransactionType persistenceUnitTransactionType, DataSource jtaDataSource, DataSource nonJtaDataSource, List<String> mappingFileNames, List<URL> jarFileUrls, URL persistenceUnitRootUrl, List<String> managedClassNames, boolean excludeUnlistedClassesValue, Properties properties, ClassLoader classLoader) {
            this.persistenceUnitName = persistenceUnitName;
            this.persistenceProviderClassName = persistenceProviderClassName;
            this.persistenceUnitTransactionType = persistenceUnitTransactionType;
            this.jtaDataSource = jtaDataSource;
            this.nonJtaDataSource = nonJtaDataSource;
            this.mappingFileNames = mappingFileNames;
            this.jarFileUrls = jarFileUrls;
            this.persistenceUnitRootUrl = persistenceUnitRootUrl;
            this.managedClassNames = managedClassNames;
            this.excludeUnlistedClassesValue = excludeUnlistedClassesValue;
            this.properties = properties;
            this.classLoader = classLoader;
            this.transformers = new ArrayList<TransformerWrapper>();
            this.tempClassLoader = new TemporaryClassLoader(classLoader);
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return this.persistenceProviderClassName;
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.persistenceUnitTransactionType;
        }

        public DataSource getJtaDataSource() {
            return this.jtaDataSource;
        }

        public DataSource getNonJtaDataSource() {
            return this.nonJtaDataSource;
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return this.jarFileUrls;
        }

        public URL getPersistenceUnitRootUrl() {
            return this.persistenceUnitRootUrl;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return this.excludeUnlistedClassesValue;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void addTransformer(ClassTransformer classTransformer) {
            TransformerWrapper transformer = new TransformerWrapper(classTransformer, this.classLoader);
            this.transformers.add(transformer);
            TransformerAgent.addTransformer((ClassFileTransformer)transformer);
        }

        public ClassLoader getNewTempClassLoader() {
            return this.tempClassLoader;
        }

        private void destroy() {
            for (TransformerWrapper t : this.transformers) {
                TransformerAgent.removeTransformer((ClassFileTransformer)t);
            }
        }
    }
}

