/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openwebbeans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.openejb.cdi.OpenWebBeansWebInitializer;
import org.apache.geronimo.openejb.cdi.SharedOwbContext;
import org.apache.webbeans.config.WebBeansContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="OpenWebBeansContext")
public class OpenWebBeansWebAppContext
implements GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(OpenWebBeansWebAppContext.class);
    private static final Map<String, OpenWebBeansWebAppContext> OPENWEBBEANS_WEBAPP_CONTEXTS = new ConcurrentHashMap<String, OpenWebBeansWebAppContext>();
    private final Holder holder;
    private final SharedOwbContext sharedOwbContext;
    private final AbstractName abName;
    private WebBeansContext webBeansContext;
    private final boolean shareableWebBeansContext;

    public OpenWebBeansWebAppContext(@ParamAttribute(name="holder") Holder holder, @ParamReference(name="SharedOwbContext") SharedOwbContext sharedOwbContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abName) {
        this.holder = holder;
        this.sharedOwbContext = sharedOwbContext;
        WebBeansContext webBeansContext = this.webBeansContext = sharedOwbContext == null ? null : sharedOwbContext.getOWBContext();
        if (this.webBeansContext == null) {
            if (logger.isDebugEnabled()) {
                if (sharedOwbContext == null) {
                    logger.debug("SharedOwbContext is null, web application {} will create its own WebBeansContext", (Object)abName.toString());
                } else {
                    logger.debug("No WebBeansContext is configured in SharedOwbContext, web application {} will create its own WebBeansContext", (Object)abName.toString());
                }
            }
            this.shareableWebBeansContext = false;
            this.webBeansContext = OpenWebBeansWebInitializer.newWebBeansContext(null);
        } else {
            this.shareableWebBeansContext = true;
        }
        this.abName = abName;
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        OPENWEBBEANS_WEBAPP_CONTEXTS.put(this.getWebModuleName(), this);
    }

    public void doStop() throws Exception {
        OPENWEBBEANS_WEBAPP_CONTEXTS.remove(this.getWebModuleName());
    }

    public Holder getHolder() {
        return this.holder;
    }

    public SharedOwbContext getSharedOwbContext() {
        return this.sharedOwbContext;
    }

    public String getWebModuleName() {
        return this.abName.getNameProperty("WebModule");
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public boolean isShareableWebBeansContext() {
        return this.shareableWebBeansContext;
    }

    public static OpenWebBeansWebAppContext getOpenWebBeansWebAppContext(String moduleName) {
        return OPENWEBBEANS_WEBAPP_CONTEXTS.get(moduleName);
    }
}

